META
key;value
description;District PB in Warszawa, Wilanów
country;Poland
unit;Warszawa
district;Wilanów
subunit;Wilanów
instance;2024
num_projects;18
num_votes;1837
budget;1521407
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
228;162810;1184;54 drzewa dla Wilanowa przy ulicy Przyczółkowej.;environmental protection,public space,urban greenery;children,seniors;1;52.14320319479273;21.095885038375858
231;45225;1142;Uzupełnienie szpalerów drzew w Al. Wilanowskiej;environmental protection,public space,urban greenery;children,seniors;1;52.16741122672479;21.078686714172367
214;220000;1132;Zakup zbiorów bibliotecznych do biblioteki publicznej w dzielnicy Wilanów;education,culture;children,seniors;1;52.158214710152414;21.087553683765645
241;60000;1084;Doświetlenie przejść dla pieszych w Miasteczku Wilanów;public transit and roads,public space;children,seniors;1;52.1642723553175;21.06993913650513
1305;45000;1034;Łąki kwietne przy szkołach i przedszkolach;education,environmental protection,public space,urban greenery;children,seniors;1;;
656;35100;1030;Czysty Zielony Wilanów;public transit and roads,public space;children,seniors;1;52.144047553733806;21.128083386588543
652;140000;1029;Drzewa przy ulicach Wilanowa Zielonego;urban greenery;children,seniors;1;52.165135250651005;21.121046075802614
528;36000;1025;Wpadnij do Biblioteki – wsparcie działalności kulturalnej placówek bibliotecznych w Wilanowie;education,culture;children,seniors;1;52.16733055;21.086674917354603
1275;100000;930;Zielony skwer nad stawem;environmental protection,public space,urban greenery;children,seniors;1;52.176747687499386;21.106967926025394
1050;30000;898;Wiata rowerowa;public transit and roads;children;1;52.16432438725659;21.0668420791626
230;165000;847;Wiata na rowery przy pętli autobusowej w Wilanowie;public transit and roads,environmental protection,public space,sport;;1;52.168299990450734;21.083471775054935
232;108070;783;Naprawa nawierzchni mostku prowadzącego do Parku Pokoleń;public transit and roads,public space,sport;children,seniors;1;52.16071864482108;21.058666706085205
227;150000;724;Nauka pierwszej pomocy;education;children,seniors;1;52.15880122058679;21.087398529052738
1718;240000;658;Przyjazna i zielona Obornicka - drzewa i krzewy wzdłuż ul. Obornickiej;urban greenery;children,seniors;0;;
566;62500;601;Drukarka 3D dla wilanowskiej młodzieży – fun & science;education,culture;children;1;52.1677837;21.0869716
1051;70000;556;Deszczochron przy Pumptraku w Powsinie;public space,sport;children,seniors;1;52.125257895169625;21.09510183334351
1254;100000;475;Wilanów haftem malowany;education,culture,public space;children,seniors;0;;
658;150000;432;Bawmy się dłużej - oświetlenie placu zabaw i siłowni przy u. Olęderskiej;public space;children,seniors;0;52.1547213;21.1333115
VOTES
voter_id;vote;age;sex
4;241,232,214,566,1050;45;F
152;230,227,241,1050,231,228,232,214;38;F
181;230,1718,227,214,528,1050,241,231,1051,228,656,652,1305,1275;43;M
269;227,231,228,656,652,566,1275;47;M
271;231,566,1305,214,528;44;F
282;241,1050;41;F
293;1254,1275,1718,652,241,1050,230,227,231,1051,228,214,656,528,1305;42;F
385;658,566,528,1275,1305,1718,230,231,228,232,656,652,1050,241,1051;36;F
401;656,232,227,228,566,1305;46;F
430;1050,1718,227,231,1051,228,232,214,656,566,658,528,1305,1275,652;33;M
534;227,232,656,652,658,1275,1305,1254,1718,231,228,214,528;61;F
536;232,1718,230,658,528,1275,1050,227,231,652,1305,241,228,214,656;45;F
700;1275,658,1051,227,230,1718,1050,1254,232,656,652,241,231,228,528;36;F
714;658,1275,656,652;52;F
811;1275,1050,230,227,231,1051,232,658,528,241,1718,228,656,652,1305;36;F
853;231,652,1305,1275,241,1254,228,656;53;M
880;656,1305,214;27;M
912;656,1305,1275,228;46;M
921;656,231,228,214,528;59;M
937;1275,656,1254,241,1718,231,228,232,652;35;F
975;652,1275;43;M
1025;214,1051,528,1305,227,1050,230,1718,241,231,228,232,656,652,1275;36;M
1099;656,652,566,214,228,231,1051,230,1718,1275,232,1050,241,1254,227;41;F
1145;230,528,656,652,1275,566,214,1305,1050,228,231,1254,241,227,232;53;M
1187;1050,231,1305,241,228;58;F
1646;528,652,241;49;F
1673;230,1050,241,232,658,1305,528,214;41;M
1726;241,1305,228,231,214,656,652,528;50;F
1733;227,658,1305,241,1718,231,1051,232,228,566,652,656,214,528,1275;37;F
1854;528,214,658,1275,232,1051,241,1050,1718,230,231,228,656,652,1305;43;F
1864;241,227,1050,231,232,214;8;M
1875;528,214,232,241,1050;44;M
1924;1050;49;M
1933;1254,231,232,528,1305;41;F
1935;656,1718,1254,230,227,652,214,528,1305,1275,566,231,228,241,1050;43;M
1971;658,652,656,214,232,1051,231,227,1718,241,228;42;F
2020;241,1050,232,214,528;11;F
2040;1051,652,1305,228,231,214,241;40;M
2056;1718,227,231,1051,228,232,214,656,652,566,658,528,1305,1275,241;31;F
2089;1050,230,228,232,214;39;M
2098;1254,1718,227,1305,1275,528,656,652,214,232,1051,1050,241,230,228;44;M
2107;1275,652,232,227,241,1718,230,231,228,214,566,528;17;F
2208;1050,1718,231,228,232,214,658,1305,1275,241,1051,656,652,566,528;47;F
2292;230,528,1275,1305,652,656,232,228,231,241,1050;42;M
2298;1254,227,566,232,1051,1718,656,652,1305,1275,241,231,228,214,528;40;M
2372;1718,232,241,656,1305,1275,652,231,228;30;M
2373;241,1050,232,214,528;8;F
2475;227,214,1305;41;F
2573;652,656,232,228,231,1051,1050,230,1718,1254,566,658,528,1275,241;34;F
2619;1051,228,231,230;38;M
2640;228,214,231;40;M
2651;1051,1718,1254,232,656,652,227,228,1050,230,1305,1275,214,658,528;41;F
2697;231,228;36;M
2793;228,1275,1254,1718,230,241,227,231,214,656,652,528,1050,1305;42;M
2815;1305,658,1275,566,214,1718,1050,241,230,231,1051,228,232,656,652;37;M
2873;528,214,232,241,1050;47;F
2899;1275,1305,652,656,232,228,231,1718,241;31;M
2926;1275,528,566,652,214,1051,231,230,1254,1305,656,232,227,241,1050;40;F
2927;214,241,227,232,1305,1050;47;F
3066;1050;44;M
3207;1050,1254,1305,1275;49;F
3240;1050;14;M
3302;214;48;M
3307;1050;9;F
3384;1051,227,1254,1275,231,1718,241,230,228,656,652,214,528,1305,1050;44;F
3432;228,1050,241,230,231,232;40;F
3468;1275,1718,241,231,1051,228,652;44;F
3477;241,232,228;42;F
3569;232,230,241,1050,1254,1718,1305,1275;45;M
3619;228;48;F
3657;1050,241,1254,1718,230,232,1305,1275;11;M
3685;528,658,652,656,214,228,231,227,230,1718,1254,241,1050,1305,1275;9;F
3766;1050,241,1254,1718,230,232,1305,1275;4;F
3793;1050,241,1254,1718,230,232,1305,1275;45;F
3882;241,1050,1718,1305,1275,231,228;35;F
3969;1050;24;M
4010;1275,1305,231,230,228,214,528;52;M
4039;566,1051,1050,214,1718,230,652,658,1275,528,1305,232,241,231,228;37;F
4098;1050,566,652,232,231,1275,1305,528,656,214,228,1051,230,1718,241;43;M
4103;1050,241,231,228,656,652,1305;31;M
4105;241;46;F
4233;1718,231,1305,1275,241,228,656,652;36;F
4296;1718,232,658,1050,1051,214,656,652,528,1305,1275,241,230,231,228;45;F
4363;1050,528,214,227,230,658,656,1275,652;40;F
4383;652,656,232,228,231;38;M
4502;1275,528,656,241;46;F
4519;227,232,214,566,658,241,1718,230,231,228,656,652,528,1305,1275;45;M
4586;652,656,232,241,231,228;48;M
4669;566,652,656,228,1051,231,227,230,1718,1254,241,528,214,232,1050;44;F
4849;1305,1275,227,1050,1718,230,231,1051,228,232,214,656,652,658,241;45;F
5147;231,652,1305,1275,228,1718,1050;40;F
5374;231,228,1275,232,1050,241,1718,1051,656,227,214,652,566,528,1305;40;F
5478;1051,656,1305,1275,241,232,1718,231,652,228;45;M
5539;1051,1275,1305,528,658,656,214,232,231,227,241,230,228,652,566;19;F
5574;1254,214,528;40;F
5719;658,1051,1254,1718,1050,230,1275,231,228,656,652,528,1305,241,214;41;F
5742;658,232,1718,1050,230,231,228,214,656,652,528,1305,1275;30;F
5750;231,228,214,656,528,241;41;F
5941;528,566,230,1051,658,1305,1050,1718,1275,228,231,232,241,656,652;31;F
5963;1305,658,232,1051,231,230,1254,241;36;F
6019;230,241,227,232,214,566,1254,1718,656,652,528,1275,1305,228,231;32;F
6093;1254,228,214;42;F
6236;1050;36;F
6251;1050,1718,232,656,652,1275,241,231,228;27;M
6335;1050,1275;37;F
6365;230,1051,232,214,1305,241,1718,231,228,656,652,566,658,528,1275;18;F
6430;1305,241,228;45;M
6431;1050;40;M
6444;1254,1275,1718,528,652,1050,214,566,241,230,227,231,1051,228,232;48;M
6569;1305,228,231,241,1050,230,232,566;11;M
6589;1718,227,566,528,1275,232,231,230,1254,241,228,214,652,656,1305;42;F
6637;231,228,214,652;27;F
6644;1050,230,566,1305;8;F
6649;241,231,228;27;M
6699;241,230,227,231,1051,228,232,566;12;M
6735;241,230,227,231,1051,228,232,214,566;10;M
6764;241,1051,228,1050,230,232,566,1305;41;M
6826;528,1050,241,231,214;42;F
6835;566,1051,1050,241,227,1275,1305,652,656,228,231,214,528;53;F
6887;528,214;50;F
6892;1050;40;M
6949;230,1051,228,232,656,652,1305,1050,241,214,528;38;M
6992;214,528;56;M
7001;214,528;36;F
7017;214;49;F
7019;214,1051,1050,241,656,528,1305;45;F
7034;241,656,658,1050,1718,214,528,1305,231,228,1051,230,1254,227,232;57;F
7067;227,214,566,528,1305,1050,241,231,1275;36;F
7083;232,1275,1305,1050,241,230,227,214,656,566,528;40;M
7118;1275,528,658,228,230,1718,1050,241,231,1051,232,656,652,566,1305;41;F
7156;241,1050,228,214,652,528,1305;38;F
7190;241,1718,214,528;61;F
7199;1254,214,528,1050,1718,230,656,241,1305,231,1051,228,232,652,1275;38;M
7208;231,227,214;50;M
7227;1718,230,1051,652,658,528,1275,227,228,232,214,656,566,1050,241;43;F
7349;1050,230,231,228,214;40;M
7392;566,232,230,1050,241,227;15;F
7399;214,652,231,228,656,1305,1275;62;F
7419;1718,230,227,1051,232,214,656,1275,241,566,1305,528,652,228,231;51;F
7430;228,232,214,1275,656,652,231,230,241,1050,1718;50;F
7522;241,656,1050,1718,230,231,228,232,214,652;50;M
7591;241,231,228,652,1275,1305;61;F
7594;241,1305,1050;39;F
7601;1305,227,1254,231,214,528;61;M
7613;1275,1305,658,214,1050,241,230,227,566;41;F
7629;1254,1718,1050,241,230,231,1051,228,656,652,566,658,528,1305,1275;43;M
7667;1254,1305,658,230,1050,241,1051,232,566;31;M
7668;1275,1305,528,658,566,652,656,214,232,228,1051,231,230,241,1050;36;F
7694;232,656,230,227,1050,652,1051,241,1254,1718,231,228,214,1305,528;21;F
7698;566,228,231,1050,232,241;38;F
7840;1050,241,1254,1718,230,231,1051,228,232,656,652,566,658,1305,1275;10;M
7914;1050,241,1254,1718,230,231,1051,228,232,656,652,566,658,1305,1275;10;M
7975;228,231,1718,230,232,656,241,1050,227,1051,214,652,1275,1305,528;42;F
8096;1718,1050,231,228,652,1305,1254,230,227,232,214,656,566,528,241;18;M
8121;1051,241,1050,230,228,214,528;39;F
8217;241,1718,228;45;F
8270;241,1050,228,214;40;F
8435;1050,241,230,232,656,566,1275;39;M
8521;652,656,228,241,1305,214,1254,227,528;40;F
8547;227,214,528,1718,1305,231,228,232,652,1275;46;F
8631;1305,231,241,656,228;70;F
8834;1050,230,1305,241,1254,1718,227,231,1051,228,656,652,1275,528,214;27;F
8956;1718,227,231,1051,656,528,214,652,658,241,228,232,566,1305,1275;60;M
9179;1050,241,232,214,528;37;F
9229;231,1051,228,214,656,652,528,241;37;F
9231;1718,230,656,652,214,228,241,231;52;F
9281;1275,656,231,214;38;F
9286;231,228,566,227,214,528;47;F
9450;528,214,1718,1050,566,1305,1275,230,1051,232,656,652,241,231,228;32;F
9559;528,230,227,232,1051,214,656,1254,1050,1718,652,1275,228,231,241;51;F
9576;214,652,528,1275,656,228,1050;45;F
9628;1050;43;F
9712;528,566,227,1254,241,1718,231,228,214,656,652,1305,230;37;F
9779;1254,227,231,228,214,656,528,1305;39;F
9807;232,241,1050;41;F
9832;214,656,566,1305,528,241,227,231;38;F
9837;241,231,228,652,1275;43;F
9944;241,656,231,214,1050;40;F
9953;528,214,230,231,228,232,241;35;F
10162;241,227,231,228,214,656,652,528;46;F
10224;1718,228,652,1305,1275,231;30;F
10279;1050,1718,227,528,652,1305,241,231,228;39;M
10308;230,214,528,1275,241,566;44;M
10353;227,1050,1254,1718,1051,228,214,652,566,658,1275,241,230,231,656;26;F
10402;1305,232,566,1718,1275,228,656,652,1050,241,230,231,1051,214,528;39;M
10422;1254,227,1051,1718,232,656,658,1275,1305,652,1050,241,230,231,228;46;M
10461;241,214,656,1305,652,1050,231,228,1275;38;F
10722;566,214,232,228,1051,227,1718,1254,1050,658,652,656,231,230,241;35;F
10741;1050,241,1718,230,231,1051,228,232,214,656,652,566,528,1305,1275;39;F
10769;1051,656,1305;36;F
10785;230,528,1275,231,241,232,656;46;M
10832;214,528,566,656,652,658,1305,1275;58;M
10893;241,231,228,656,1305;33;F
10913;1050;42;F
11006;652,228,241;30;M
11112;241,231,228,214,566,528;42;F
11148;230,228,656,1305,1275,231,232,652;46;F
11200;1254,241,1718,230,227,231,228,232,214;57;F
11274;1050,228,232,214,528;35;F
11282;241,230,231,528,1275,214;24;M
11324;230,227,656,241,1254,214,566,528,1305;29;F
11333;656,232,241,1050,566;38;F
11361;1275,1305,656,228,1051,241,231;43;M
11460;230,214,528;44;M
11507;652,1305,1050,227,214,566,528;47;F
11635;230,227,231,228,652,656,566,214,528,1275;39;F
11747;1050,230,1051,656,652,528,1275;44;M
11906;528,1275,1051,232,214,566,656,241,1050,1718,230,231,228,652,1305;40;F
11908;1275,1718,227,656,528,1050,241,230,228,214,652,566,658,1305,231;34;F
11924;1305,214,241,1050,227,228,232,656,652,566,1275;39;F
11980;1050,658,1305,528,214,656,1718,1275,652,232,1051,231,241,230,228;28;M
11986;1275,1305,528,658,652,656,214,228,231,227,230,1718,1254,241,1050;4;M
11992;1275,652,241,1050,231;38;F
12009;241,227,656;69;M
12094;241,230,227,232,566,1305,1275,1050,528;47;F
12214;231,1305,652,1050;40;F
12289;230;39;M
12416;230,231,528,1718;40;F
12466;1275,227,656,1305,1050,214,232,228,231,241;40;F
12520;528,652,231,656,228,1050,241;39;M
12547;214,227,231,1305,230;48;F
12578;241,230,231,228,656,652;48;M
12639;230,231,214,566,658,528,1050,241,232,656,1305,1275,1718,228,652;38;M
12695;1050;38;M
12954;1718,230,566,1305,528,652,214,227,231,241,1051,228,656;38;F
12965;232,228,231,1050;39;M
13030;227,214,1305,652,656,228,1050,231;37;F
13034;241,1718,228,232,656,652,1275,1305,231;36;F
13039;1275,228,214;34;F
13097;231,241,1305,1050;46;M
13129;1254,214,528;2;M
13224;566,1718,1050,241,227,652,1275,231,228,656,1305,232,1254,214,528;40;F
13284;1051,658,652,656,232,1718,241,1050,230,528,1305,1275,231,228,214;40;F
13423;1305,656,1254,227,231,214,528;5;F
13448;1254,656,1305,652,231,228;36;F
13476;1275,1051,241,231,228,652,566,1305;35;F
13665;1050,230,232,214,656,566,528,1305,241,231,1051,228,652;36;F
13691;228,652,227,231,232,241,1050;40;M
13774;231,228,656,652;47;F
13895;1254,227,231,228,214,656,528,1305;3;F
13920;566,1305,1275,652,656,228,231,1050,227,232,214,528;34;F
14026;214,232,231,1275;37;F
14133;1275,1305,1254,1718,231,228,214,656,652,528;38;F
14155;230,658,241,214,528,232,1051,1254,1718,231,228,656,1305,1275,652;15;F
14205;214,528;77;F
14419;1051,214,528,566,1305,232,1718,227,1275,656,230,231,228,652,658;47;F
14482;652,528,214;65;F
14537;1050,1275,230,214,528;48;M
14559;227,231,228,232,214,528,1050;38;F
14643;1050,227,566,1718,230,1305,241,1254,231,228,214,656,652,528,1275;47;F
14703;241,231,232,228,1305;31;M
14729;1050,1254,230,214,241,1718,231,228;15;M
14934;232,1050,1051,1305;39;F
15034;656,231,1050,230,227,228,214,528;47;F
15189;528,214;36;F
15264;1275,231,214,1305,230,652,656,228,528,232,1050,241;45;F
15329;231,228,1305;41;M
15413;231,227,228,656,652,566,1305;36;F
15492;1718,1275,652,232,228,1051,230,1254,241,1050,566,231,1305,227,214;35;F
15707;227,1254,232,528,656,228,231,230,241,652,214,1050;39;F
15714;1718,1050,1305,652,228,231,1254,241,232,656,1275;65;F
15758;1254,1050,241,656,652,566,1275,1305,1051,230,228,214,528;41;F
15849;1051,230,1718,241,227,231,228,232,214,656,652,658,528,1305,1275;26;F
16072;1275;51;M
16110;1275;47;F
16266;1050,1718,231,232,656,652,658,1275,1254,1305,528,566,214;40;F
16344;658,656,1275,1305,528,652,232,228,227,230,1718,1050,241,231,214;38;F
16350;1254,1718,230,231,228,214,656,652;44;M
16417;241,231,228,656,652;43;F
16590;228,231,214,528;72;F
16595;1254,652,528,1275,214;43;F
16656;1254,1305,1050;39;F
17251;232,1254,230,227,528,1305,656,1050,241,231,228;37;M
17296;1254,1050,566,656,227,241,228,652,1275;34;M
17428;241,228,232,656,566,528;55;F
17488;658,566,528,1305,652,656,228,1051,227,230,1050,241,231,232,214;37;F
17529;1718;11;M
17567;228,214,656,658,528,1275,227;67;F
17650;232,1254,1050,658,1718,227,566,228,656,652,1275,231,241,214,528;41;F
17665;1275,1305,528,652,214,228,231,1050,232;43;F
17882;214,227,241,1050;40;F
17934;241,228,214,656,652,528,1305;33;F
18043;1305,1254,1275,214,528;34;F
18051;1305,528,658,566,656,232,1051,241,227,214;34;F
18126;241,227,232,656,1275;44;F
18168;1254,658,566,656,214,232,1051,227,230,1718,241,231,228,652,1305;33;F
18287;1718,652,231,228,656,1305;46;F
18290;1254,241,1718,232,656,528,231,227,1050,214,652,230,228,1305,1275;38;F
18490;214;40;M
18511;214;9;M
18539;1050,1275;40;M
18554;214;38;F
18560;214;8;F
18567;214;6;M
18579;231,241;41;F
18840;241,1718,1254,1275,1305,528,658,228,232,1051,231,1050,652,230,214;19;M
18874;1254,1050,214,1718,528,228,1051,230,1275,1305,658,652,656,241,231;31;M
18875;1718;28;F
18897;1275,658,652;45;M
18938;231,656,652,1275,228,214;50;F
18945;566,227,1050,1718,230,1051,232,656,658,1305,1275,241,231,228,652;38;M
18946;1051,658,1050,227,230,1718,1275,656,232,241,231,228,214,652,1305;32;F
18951;214,528,1275,1305,241,230,227,231,228,232,652,656;37;F
18976;1050,231;39;F
19045;241,231,228,656,652;42;F
19072;230,227,231,1051,232,652,566,658,528,1275,1305,1050,241,228,656;38;F
19094;566,528,1275,658,1051,230,1718,232,1305,1050,241,231,228,656,652;36;F
19110;214,528,241,231,228,1305;45;M
19131;227,1718,1254,1050,230,231,1051,228,232,652,658,1305,241,656,1275;38;F
19172;241,1051,232,214,566,658,528,1305,1718,227,231,228,1275,656,652;30;F
19177;241,231,228,214,528,1305;13;M
19187;1305,1718,227,231,228,214,528;31;F
19194;230,227,231,232,652,566,1050,241,1275,656,214,228,1051,528,1305;36;F
19195;241,231,228,214,528,1305;11;F
19276;232,214,656,652,566,1305,241,230,231,228;45;M
19337;241,1718,228,232,214,656,652,231;41;M
19438;227,1051,528,1718,1275,566,1305,231,656,228,652,232,241,214,1050;40;F
19442;214,528;73;F
19456;1275,1305,528,656,214;38;F
19502;1718,1254,230,658,241,1050,656,652,1275,232,231,1305,228;36;M
19791;241,231,656,1305,228,1050;45;M
19858;1051,658,227,1718,1050,214,1275,232,652,566,241,231,228,1305,528;38;F
19880;658,656,232,227,1305,1275;41;F
20093;1718;44;M
20097;1718;78;F
20223;232,656,228,214,528;56;F
20259;658,241,1718,230,1051,228,528,1305,1275,214,656,652,232,231,1050;42;F
20601;214,228,230,1718,1050,227,1275,528,658,566,652,656,241,231,1305;32;F
20829;241,656,228,214,652,528;32;F
20962;231,1718,241,228,656;18;M
21260;1254,652,658,1275;39;F
21274;1050,231,214,656,1305,1051,228,652,1275;41;F
21549;1051,1305,1050;48;F
21802;227,1051,566,1305,230,1050,1718,231,656,652,1275,1254,228,214,528;20;F
21835;214,1275,1050,227,241,230,231,228,232,652,1305;35;F
21844;241,230,228,232,656,652,566,658,1305,1275;32;F
21888;658,214,228,227,1718,241,230,231,232,656,652,566,528,1305;39;F
21934;1305,652,656,231,214,528;40;F
22015;1275,528,658,656,230,227,1050,241,231,1051,228,232,214,652,1305;36;F
22153;1305,658,1051,230,1050,241,227,231,228,232,214,656,652,528,1275;36;F
22281;1050,241,228,652,528;42;F
22330;1051,227,652,1305,1254,214,528;42;F
22362;1254,227,231,1051,228,232,656,652,566,658,528,1305,1275,1050,241;41;F
22385;1718,1051,658,1275,241,230,231,228,232,214,656,652,566,528,1305;34;F
22464;1718,231,228,652;46;M
22488;241,1050,231,1051,228,656,652,1305;34;F
22492;656,231,241,1050;39;F
22496;566,214,227,241,231,528,1305;40;F
22541;1050,241,230,231,228,232;49;M
22555;1051,566,1718,1254,241,1275,528,658,214,231,227,228,656,652,1305;38;F
22630;1718,230,231,1051,228,232,214,656,652,566,1305,1275,528,227,1254;39;F
22638;230,232,214,656,658,1305,1275,227,1051,528,241,231,228,652,566;35;F
22790;227,1050,231,232,652,656,528,1275,1305,241,228,214;31;F
22855;241,230,231,232,656,652,658,1305,1718;31;F
22857;1275,1718,231,652,566,232,656,528,214,228,227,241,1050;42;F
22924;1050;44;M
22961;1050,1718,1254,1051,214,230,656,652,566,1305,1275,241,231,228,232;40;F
22965;1051,566,1718,1254,227,652,656,1275,228,1305,232,528,231,241,214;35;F
22990;231,228,232,1305,528,652,241;36;M
23001;1051,232,566,230,214,1275,1050,528,241,228,656,652,1305,227,231;53;F
23007;1305,1275,652,656,231,227,230,1718,1254,241,1050,228,214,566,528;32;F
23022;241,231,228,232,1275,1305,1718,656,652;34;F
23165;656,228,230,1718;45;F
23253;1050,1718,230,227,1051,232,214,658,528,1275,231,228,656,652,566;32;F
23340;1050,1275,1305,528,656,232,227,1718,231,228,652;39;F
23523;652,241,231,228,214,1305,528;36;M
23540;227,528,214;42;M
23633;228,656,652,566;32;M
23640;1051,230,241,1254,1718,227,231,228,656,652,566,1275,1305,214,528;31;M
23666;1718,241,232,214,656,566,658,230,227,231,228,652,528,1305,1275;38;F
23679;528,652,231,1718;43;F
23680;1718,231,228,652;43;M
23697;1275,231,228,214,227,656,652,528,1305,1050,241;40;F
23725;230,1050,528,658,231,1718,1254,228,214,1305,1275,241,232,656,652;35;F
23769;230,1305,1050,241,228,214,656,652;33;F
23790;1050,227,231,1051,656,652,566,658,1275,232,214,528,1305;37;F
23803;1051,228,656,652,1305,1275,231,227,241;43;F
23888;1051,232,241,1718,566,656,658,1275,652,228,231,1050,1305,214,528;43;F
23916;232,241,1050;51;M
23924;1050,231;46;F
23954;241,1254,227,652,1305,528,566,214,228,231;26;F
23970;241,1718,1051,214,652,1305,1254,1050;36;F
23999;241,1718,230,231,1305,1275,566,652,656,232,228,227,214,528;47;M
24002;241,1051,1050;36;F
24017;227,214,230,232,658,528,1718,231,228,656,652,1305,1275,241,1050;48;M
24042;1254,1718,566,1305,528,652,656,241,227,1051,228,214,1275,1050,231;39;M
24091;1050,231;41;M
24116;1050;44;M
24126;528,1050,1254,1718,1305,658,214,232,230,231,1051,228,656,652,1275;46;M
24164;228,528,656,241,1050,230;39;F
24168;230,1051,232,528,1718,228,652,1305,1275,231;45;F
24174;232,658,566,1305,1275,1050,241,1718,230,227,231,228,214,656,652;76;F
24192;1050;50;F
24204;1050;49;M
24220;241,227,1051,232,214,528;40;F
24221;1050,241,227,1305;42;F
24230;1050;71;M
24254;214,528;37;M
24261;241,1718,230,227,1051,232,656,652,566,528,1275,1050,231,228,214;38;F
24273;566,227,528,1305,231,228,214,652;46;M
24280;214,231,230,241,1050,566;40;M
24284;528,1254,1718,231,228,232;64;F
24291;528,656,230,1050,241,227,1051,214;42;F
24305;1718,658,652,656,232,228,231,1050,241,1254,227,214,528,1305,1275;47;F
24315;214,228,652,227,231,566,528,1305;44;F
24336;1275,652,1718,227,231,214,1305,228,241,1050;40;M
24376;1305;22;F
24380;1051,1050,228,231;39;F
24383;1050,241,1254,1718,230,227,231,228,656,652,1275;31;F
24397;1305,656,1718,1050,241,1275,652,232,228,231;36;M
24405;566,228,241,231,1050;45;F
24432;1718,231,228,1275,1305,656,232,230,1050,241,227,1051,214,566,528;36;M
24439;241;47;M
24457;232;33;M
24474;214,1275,230;23;F
24506;1254,231,228,214,528;56;F
24518;1050;37;M
24552;232;34;F
24568;528,1254,214;82;F
24569;1050;36;F
24612;1050;35;M
24626;1050,1254,1718,1305,1275;75;F
24664;230,1050;32;F
24667;528,1718,228,1305,1275;31;F
24669;1050;53;F
24730;1050;40;F
24796;241,227,214,528,1050;39;M
24809;1050;50;F
24855;214,1275,1305,652,1718,1050,241,1254,230,227,231,228,656,566,528;29;F
24859;241,1254,230,227,1051,656,658,1718,231,228,214,652,566,528,1305;5;M
24875;228,231,652,656,1050;47;F
24892;1051,652,228,656,232,231,227,230,241,1275,1305,1050;45;F
25184;232,652,1275;36;M
25190;1718,227,1254,566,658,528,1275,230,1050,231,228,232,214,1305,241;46;M
25290;1254,566,656,214,1050,241,230,232;39;F
25318;1275,1305,528,566,652,214,232,228,231,227,230,1254,1050,241;35;F
25328;231,228,652,656,241,1050,1275;39;F
25414;232,528,214,566,1275,652,656,228,231,1051,227,1050,241,1254,1305;48;F
25419;241,1050,566,1305,1718,230,227,231,228,232,656,652;43;F
25422;227,1050,1718,1051,228,656,566,230,231,214,652,528,1305;40;F
25521;1254,228,231,241,1050;46;M
25566;230,656,1275,1305,227,228;56;F
25634;1275,1305,528,658,652,214,232,228,1051,231,230,241,1050;39;M
25676;1275,1305,566,652,214,656,1051,231,227,230,1718,1254,241,1050,228;43;F
25696;230,227,1051,214,1050,1718,231,228,656,652,528,1305,1275;51;M
25853;658,652,656,214;53;F
25858;656,652,658;71;F
25866;1050;38;F
25926;528,656,1050,241,227,566;45;F
25970;652,1051,230,1254,241,1275,1305,528,232,1050,227,214,656,566;9;F
25985;1718,658,566,652,656,1051,228,231,227,1254,1305,232,230,241,1050;41;F
25997;230,1051,228,1305,656,227,231,1254,241,1050,214,528;41;F
26005;228,656,652,566,528;17;F
26017;656,241,230,228,232,528;65;F
26044;214,528;46;M
26057;228,1051,230,1718,231,566,658,1305,1275,652,227,1050,241,214,656;13;F
26086;1051,214,566,1305,528;46;F
26118;241,1718,227,228,232,214,528,656;11;M
26142;1718;74;F
26212;230,227,214,658,1305,1050,241;40;F
26213;227,231,232,1305,528,214,241,1050;50;F
26255;1050;43;M
26292;1305,1050;40;F
26345;1050,528,241;40;F
26378;231,1050,1305,652,228,230,1718,241,227,232,214,528,1275;33;M
26399;227,228,214,652,528,1305,1050,1254,231,241,656;49;F
26440;228,656,214,528;36;F
26449;1254,230,227,1051,232,214,658,528,1275,656,566,1305,228,231,1718;33;F
26528;241,656,1305;35;F
26560;656,528,241,231,230,228,214,1254;27;F
26567;241,1254,1718,230,231,1051,228,214,652,656;11;F
26587;1050;43;M
26677;1275,1305,528,652,214,227,230,1050;46;F
26732;232,652;41;M
26734;1050;40;F
26768;1275,1305,566,652,214,232,1051,227,1254,241,231,228;38;F
26791;1050,241,232,214;36;F
26822;231,228,1254,656,652,1275,1050,241,230,227,1051,658,1305,214,528;38;F
26877;1050,528;40;F
26900;1305,231,1718,241,230,227,228,652,1050;51;F
26945;528;17;F
26957;1050,1718,1275,656;53;F
26970;241;37;F
26990;652,231,1050;37;F
27000;1050;41;F
27008;231,228,232,656,1305,227,230,1050;37;F
27032;1050,227,656,652,566;36;M
27090;1050,241,231,228;49;F
27110;1718,658,1275,566,231;35;M
27126;228,566,658,1305,214,1275,528,652,232,241,656,1050;35;F
27152;1275,528,658,656,214,232,230,1051;41;M
27180;1305,652,656,232,228,230,1050,241,231,214,528;45;M
27288;241,232,1050;38;M
27293;1050,232,214,528;42;F
27300;1305,528,566,652,656,214,232,228,231,227,230,1718,1254,241,1050;43;F
27339;1254,656,230,241,227,231,1051,228,1305,214,528,1050,232;38;M
27546;1050,241,1051;52;F
27566;214,528,1254,231,1718,230,1051,228,652,656,658,1305,1275,241,232;41;F
27582;230,1050;40;M
27623;1305,232,656,528;41;F
27661;1275,658,232,230,227,231,1051,228,656,652,566,1050,1305;39;F
27710;1275,656,241,1305,214;46;F
27757;656,214,241;33;F
27950;1050;39;F
27952;230,1275,1718,232,652,227,231,228,214,656,528;47;F
28021;658,231,566,1275,230,232,1051,214,528,1305,656,228,227,241,1050;48;F
28074;1050,1254,241;41;F
28084;566,231,228,1050,241,1305,214,528;40;F
28146;1275,528,1254,241,1718,232,656,652,1305,231,228;35;F
28330;652,1305,1275,241,231,228,656;27;F
28400;1275,1305,528,228,227,656,214,241;49;M
28526;230,1275,241;19;M
28594;1718;71;F
28608;1050;44;F
28678;1275,1050;37;F
28782;241,214,528,1050;39;F
28855;656,652,1275,231,228;37;F
28899;227;18;F
29021;1275,1050,228,652;42;M
29064;1050,214,528;47;M
29242;1254,566,1051,1718,232,1305,658,241,231,1275,528,652,228,227,214;59;F
29296;231;30;M
29355;232,230,227,231,214;52;M
29593;1305,1275,566,656,1050,241,230,232,214,528;37;F
29606;528,1305,652,656,214,228,231,241,1718;36;M
29641;1050;43;F
29763;1718,1050,241,1254,231,1051,228,232,214,566,528,1305,1275;49;M
29810;227,230,1254,241,652,656,1050,1305,1275;36;F
29901;230;18;M
29995;658,652,228,1051,231,1050,241,227,232,1305,1275,230,656,566;38;M
30023;232,528,241,1718,231,228,214,656,652,1275,1305;22;F
30083;232,214,566,528,1305,228,656,658,1275,652;33;M
30212;1050,241,230,231,228,232,214,656,652;34;F
30233;1050;40;F
30263;1050,232;42;M
30276;528,656,231,230,241,1050;38;M
30312;566,1718,241,1050,214,656,528,230,227,228,1305,1275;36;F
30313;214,1275,1305,528,228,231,227,241,1050;39;F
30324;230,1254,1275,214,241,1050,231,1051,228,232,1305;41;F
30359;658,1254,1718,528,1275,566,652,232,228,231,227,230,241,656,214;34;F
30367;227,528,656,652,231,228,214;50;F
30402;1718,1275,652,1050,241,1254,230,231,1051,228,232,214,656,528,1305;9;M
30409;528;45;F
30452;1254,241,1718,1051,1050,230,228,232,214,656,652,528,1305,1275;41;M
30454;658,1305,656,232,231,566,1050;10;M
30528;1050,1718,230,227,231,1051,228,656,652,566,658,1275;71;F
30561;228,214,1050;39;M
30654;241,656,232,1718,214,1275,652,228,231;41;M
30845;566,528,241,1718,227,232,214,652,1305,1275,1050,1254,230,231,228;35;F
30852;228,652,231,1305,1050,232,566;45;F
30896;232,1050;43;M
30964;231,214,528;76;M
31042;1050;53;M
31135;656,652,1305,1275;58;M
31171;1050,241,230,231,228,656,652,1305;14;M
31217;656,241,1050,230,228,652,566;14;M
31299;658,1718,1254,228,566,1275,1305,528,652,656,214,232,227,241,1050;42;F
31338;230,656,528,241,1718,231,228,214,652,1305,1275;52;F
31369;214,566,1050,241,1718,230,231,1051,228,232,656,652,658,1305,1275;42;F
31385;231,228,214,652,528;52;M
31400;1050,1275,528,658,566,652,227,1718,232,228,231,241,656;37;M
31499;652,656,241;31;F
31507;227,214,528;47;F
31575;230,1718,228,214,656,652,1305,1051,231,241;13;M
31631;1305,656,652,241;51;M
31680;1275,1305,658,241,1050,230,231,1051,228,232,214,656,652,566,528;15;M
31802;1050,658,656,1305,1275,652,228,230,566,231,241,1254,528,227,214;50;F
31825;656,566,528,1305,1275,241,1254,227,228,214;41;M
31853;1254,1051,1275;66;F
31859;230,1275,1050,214,528;57;F
31864;652,241,230,227,231,228,656,566,658,1275;68;M
31878;566,656,1050,1718,227,528,214,1254,228,652,1305,1275,241,230,231;44;F
31908;652,232,228,227,656,214,231,241,528,1305;41;M
31975;1050,241,230,227,231,228,214,566,1275;64;M
32123;241,230,231,228,214;56;M
32216;652,228,231,230,1718,232,1305,1275,214;41;F
32228;1050,1718,228,566,1305,1275,214,230,241,227,231,232,656,652,528;41;F
32312;1305,230,1275,656,214,528;53;F
32323;241,1305,214,1718,528,231,228,1050;48;M
32529;656,228,214;43;M
32650;1050;39;F
32654;1275,658,230,227,1050,231,1051,228,656,652,1305,232,214,241,528;41;F
32664;1050,241,1254,230,1051;16;F
32682;1050,658,232,1275,1305,566,231,1718,241,230,227,1051,228,656,652;45;F
32716;1275,1305,652,1718,230,232,528,231,228,214;41;M
32861;1305,528,566,214,232,228,1051,231,227,230,1718,1254,656,241,1050;37;F
32951;566,241,658,230,1718,1050,1275,1305,652,232,231,1051,228,656;44;F
32966;1050,241,230,1051,232,214,658,528,1275,1718,231,228,656,652,1305;34;M
33019;1275,1050,241,230,1051,232,214,528;38;F
33031;652,231,1275,1051,658,1305,227,228,1050,241,230,232,214,566,528;49;M
33043;232,658,241,231,656,1275,228,214,1254,1050,227,652,566,528,1305;50;F
33058;228,528,1050,241,1254,230,1051,232,214,656,652,566,658,1305,1275;36;F
33090;1275,652,232,1051,1254,1050,241,230,231,228,1305,214,656,528;28;F
33155;1050,232;35;F
33174;241,231,214,656,652,528,1305;49;M
33331;1305,231,1254,214,528;67;F
33350;1050;43;M
33373;232,230,1718,1050,241,231,228,656,652,1275;32;M
33412;214;44;F
33459;1050;45;M
33528;566,241,230,227,231,1051,228,232;42;F
33542;652,656,228,1050,214;43;F
33784;566,230,1050,241,1254,1718,227,228,214,652,1305,1275,656,231,232;35;F
33883;227,1718,230,228,656,652,658,528,1305,1275;45;F
33907;566,214,230,1050,1718,1051,232,1275,1305,227,241,231,228,656,652;47;M
33918;241,231,1051,228,232,214,652,566,528,1305,1275;40;M
33931;656,241,1718,227,214,528;69;F
33998;1275,652,1718,1305,1050,1254,231,656,228,232,1051,230,241;44;M
34005;241,1050,230,1718,1051,231,656,214,232,228,566,658,528,652,1275;41;F
34068;230,227,232,214,656,566,528,1305,1275,1050,241,1718,231,228,652;34;F
34102;241,231,228,232,652,1305,1275;29;M
34306;1305,1275,652,656,228,231,214,528;45;F
34345;656,241,1254,232,652,1050,231,228,1275;62;M
34464;1305,214,528,228;65;F
34493;656,228,230,1305,1050,241,231,528,214;33;F
34496;566,658,656,528,1275,230,227,231,228,1050,241,1254,1051,232,214;50;F
34770;1305,528,658,652,656,214,232,228,1051,231,230,1718,241,1050,1275;38;F
34800;214;44;F
34863;656,652,1305,1275;39;M
34896;231,1718,1050,1254,232,566,656,652,658,1305,1275,241,228,214,528;13;F
34897;230,1254,1718,227,231,228,232,656,566,1050,241,1051,214,528,1305;39;F
34900;227,214;52;M
34906;241,1050,214;38;M
35191;227,1050,241,1254,1718,230,231,214,656,652,528,1305,1275;34;F
35234;1050,230,228;31;M
35556;1275,656,214,227,1050,241,1718,231,228,652,1305;40;F
35602;1275,528,652,656,232,231,227,1050,241,228,214;39;F
35622;1050,1718,227,231,1051,228,232,214,652,656,658,528,1305,241,230;42;F
35643;228,652,214,241,231;46;M
35698;566,528,1275,214,227,1050,232,658,1305,231,230,1718,241,228,652;56;F
35796;231,230,1718,1254,528,1305,1275,658,566,214,232,228,227,1050,241;40;M
35855;528,1718,227,1051,656,658,1275,1305,1050,241,230,231,652,228,232;35;F
35945;1050,241,230,231,228,232,214,566,528;39;F
35983;241,656,1050;38;M
36058;1051,566,227,1050,228,232,241,230,231,656,652,1305,1275,214,528;87;M
36110;1254,227,231,232,528,1305,1275,241;48;F
36251;1718,227,231,1051,228,656,1305,230,214,528;43;F
36277;1305,528,658,566,656,232,1718,1050,214,652,1275,228,231,230,241;42;M
36284;1050;37;M
36640;566,1718,1050,230,227,1051,214,528,1305,231,228,656,652,241;33;F
36652;1275,656,1254,241;46;F
36703;1050,1254,227,528,1718,652,1275,1305,1051,214,228,231,230,232,241;47;F
36813;231;73;M
36868;1050,231,228,214,652,656,566,528,1305,241,227;38;F
36896;227,658,232,1254,656,1050,1718,214,566,1275,528,1305,231,228,652;66;F
36917;1275,1305,528,658,566,652,656,214,232,228,1051,231,227,1718,241;22;M
36996;232,230,1050,1718,214,566,658,528,1305,1275,1254,652,656,231,228;44;M
37010;214;76;F
37060;652;44;F
37101;241,227,214,652,528,1275;46;M
37167;566,241,1275,652,228,1718,528,214;18;F
37255;656,241,1050;55;M
37269;227,1254,241,1050,214,656,652,528,1275;63;F
37285;1051,227,658,1275,1050,241,1718,230,656,652,528,1305,231,228,214;31;F
37464;228,1254,231,1275,1305,658,566,232,227,241,230,652,656,528,214;38;M
37635;227,1718,656,652,528,1275,1050,241,230,231,1051,228,214,566,1305;39;F
37653;231,228,214,652,528,1305;83;F
37714;231,1254,1718,230,227,1051,232,214,656,652,566,658,528,1305,228;39;F
37929;230,652,241,231,228,1275;49;M
38191;1305,658,652,656,228,227,1050,241;40;F
38195;1305,228,231,227,241,1254,214,566,528;38;F
38416;1050,230,228,232,656,652;45;M
38454;241,231,228,214,528;37;M
38477;1050,232;38;M
38533;1275,1305,232,1050;34;F
38545;652,656,227,228,1305,1275;41;F
38671;566,658,528,227,1718,1275,1305,652,656,214,232,228,231,1254,241;29;F
38783;241,1718,1305,658,231,232,652,566,1275,230,227,228,214,656,528;64;F
38859;214,227,230,241,231,652;48;F
38945;214,528,1305;56;M
38948;231,241;41;M
39060;1050;52;M
39107;228;35;M
39406;1718,1051,228,1305,1275,241,656,528,1050;44;F
39440;1718,227,231,1051,228,656,1305,652;47;F
39531;214;58;F
39547;231,228,566,652,214;62;F
39639;1254,1718,228,232,214,656,652,1275,231;43;F
39743;1305,241,231,228,214,528;39;F
39879;1305,230,1718,232,214,656,528,1275;37;F
39947;1718,528,214;56;M
39950;528,241,1254,231,228,214,656,652,1305;37;M
40159;1050;44;M
40580;1718,227,230,241,231,1051,228,214,656,652,658,1305,1275,1050,232;39;M
40602;658,1051,227,1254,1050,241,1718,230,232,656,652,1305,1275,231,228;39;M
40701;241,231,1718,658,652,656,214,232,228,1051,227,230,1050;42;M
40716;1718,227,232,214,652,566,658,528,1305,241,1050,1254,230,231;26;F
40722;1050,241,656,652,566,1305;38;M
40790;230,232,228,528,231,1050,241,566,214;38;M
40888;656,566,658,528,1275,230,1050,1718,228,232,214,652,1305,241,231;56;F
40909;231,227,230,1718;50;F
40928;228,652,656,1275,1305,1050,231;38;F
41105;230,227,232,656,1305,528,658,228,1051,1254,241,1050,231,214,652;40;F
41175;1718,231,652,1305;47;F
41273;566,232,230,1718,1275,1050,241,231,227,1051,228,214,656,652,528;42;F
41375;230,1275,1305,528,652,214,228,231,1718,1050,241,1254,227,232,656;38;F
41510;231,232,656,241,230;34;M
41542;1050,528,656,230,227,241,1254,1718,231,228,232,652,566,1305,1275;71;F
41592;214,528;39;F
41604;214,528,1305,1275;38;M
41623;528,214;12;M
41865;227,228;49;M
41867;1050,1718,656,652,658,528;34;M
41930;1050,1718,656,652,658;35;F
41933;1050,1718,652,658,528;65;M
42086;1305,241,232,230,227,231,228,214,528;43;F
42100;232,1718,231,241,214,528;63;F
42119;1275,1305,241,231,214,528;40;F
42543;656,652,1275,1305,227,214,528;52;F
42612;1305,227,1050,241,231,228,652,528,214,656;38;F
42665;1718,528,652,214,231,1305,227,241,228,656;37;F
42869;656,652,1275,1305,1050,230,231,228,214,528;37;M
42925;528,214,1718,231,228,652;39;F
42947;241,230,1051,228,232,656,652,658,1305,566,231,227,214,528,1275;56;F
43063;528,1254,214;55;F
43081;241,231,228,652,1305,1275;37;F
43127;1051,230,1254,1718,227,652,231,228,232,214,656,1305,528,1275,1050;38;F
43174;658,656,232,1050,230,227,1051,214,566,528;36;F
43212;214,528;78;M
43264;228,214;23;F
43304;1254,241,231,228,232,214,528,1305;7;F
43324;241,227,228,656,652,566,1305,1051,214,528;41;F
43379;241,214,528;36;F
43433;1275,230,1718,1050,231,241,1051,228,232,656,566,1305,227,214,528;43;F
43591;227,230,241,1305,528,214,231,1718;39;F
43670;227,231,228,528,241,566,1305,1050;41;F
43704;1305,1254,566,528,214;41;F
43731;1254,1275,1305,528,658,566,656,232,228,231,227,230,241,214,652;37;F
43737;231,1051,241,1050,230,228;28;F
43838;658,232,227,230,1050,241,1718,231,228,214,656,652,528,1305,1275;39;F
43858;566,656,232,1051,227,1718,1050,241,230,231,228,214,652,528,1275;39;F
43877;1051,1718,230,231,658,214,528,1305,652,656,232,228,1050,241,227;39;F
43902;1254,1275,528,566,656,227,1718,1050,241,231,230,228,1051,652,1305;39;F
43926;1051,241,1050,231,230,1718,232,656,652,658,228,214,528,1305,1275;71;F
44055;1718,231;44;F
44125;658,528,652,656,227,1718,231,1050,241,230,232,566,228,1305,1275;35;F
44180;228,231,214,528;56;F
44191;1050,1254,1718,227,656,652,566,1305,241,231,228,214,528,1275;42;F
44258;1305,528,214,1051,231;36;F
44322;1305,656,232,1050,241,227,231,230,228,1275;27;F
44325;1050,528,241,214;39;M
44372;230,1050,214,1275,528,227,1718,241,231,228,232,656,652,566,1305;44;M
44400;1305,1275,1050,241,1254,227,231,232,656,652,566,230,228,214,528;63;F
44402;656,652,1275,228,214;48;F
44413;228,656,231,1718,1254,1051,652,1050,232,1305;36;F
44549;1305,656,231,241,227,228;21;F
44743;1050,528,1305,1275,231,227,1254,230,232,652,566,228,1051,656,214;21;F
44777;1050,1254,1718,1305,1275;65;F
44939;241,1718,230,1051,1050,231,228,232,214,656,652,566,528,1305,1275;32;F
44967;1305,228,1050,232;42;F
45003;1305,1275,1718,228,1050,241,1254,230,227,231,232,214,656,566,528;50;F
45036;241,231,228,232,656,652,1305;49;M
45104;1050;9;M
45159;1050,227,656,230,232,214,528;46;M
45490;656,1718,1275;44;F
45503;230,1305,566,652,656,231,1718;49;M
45538;1050,214,566,528;60;F
45582;1050;4;F
45604;228,1275,231,1305;32;M
45827;656,652,1718,1254,230,227,231,228,214,566,528,1305,1275;82;M
46502;528,214;49;F
46524;1275,656,232,241,1718,231,228,652;37;M
46642;241,1051,1275,1305,528,214,232,228,230,1254;31;M
46670;656,1050,1051,652,1275,566,241,1254,230,227,231,228,232,214,528;31;F
46976;1050,656,241,214,528;37;M
47050;232,528,656,652,566,658,1275,230,1718,241,1050,227,228,1305,214;11;M
47288;1050,232,1051,231,230,1718,1305,1275,652,228,1254,241,214,656,528;20;F
47409;1050,1254,230,232,652,1305;27;F
47416;227,232,214,528;74;F
47497;241,231,214,528,1305,1254,1718,227,228,232,230,1050,656,1275,652;24;F
47645;232,1254,1050,227,214,656,1275,231,230,1718,528,228,652,566,1305;25;F
47650;1275,1305,528,1050,230,241;38;F
47663;566,652,528,214;69;F
47675;241,230,231,228,214,528;11;M
47729;1718,227,231,1051,228,232,1275,1254,658;26;F
47741;1305,656,227,228,214,528,1275;47;M
47955;566,652,656,214,232,241,230,231,1051,228;16;M
48068;1254;28;M
48120;227,230,1718,1051,228,656,528,1275,241,231,232,658,1305,652,566;47;F
48125;1718,227,231,232,566,658,1305,1254,1275,1050,241,1051,228,214,528;35;F
48255;658,656,227,1718,1275,1050,230,228,652,566,1305,241,231,528,214;45;F
48287;1050,241,656;39;M
48431;566,652,656,1051,230,241;37;F
48609;214,528;63;M
48678;1275,658,232,228,231,230,1254,241,1050,214,528;39;M
48834;228,214,566,1275,528,658,652,656,232,1051,230,241,1305,231,1050;37;F
48888;1275,658,1050,1718,230,227,228,232,652,566;54;F
49004;566,652,1275;39;F
49152;528,241,227,231;47;F
49294;566,1050,1275,228,230,1718,1305,231,241,232,652,214,656,1254,528;18;F
49329;230,231,1275,1305,528,658,566,652,656,1051,1254,241,227,232,214;37;F
49344;1275,1305,232,230,656,231,1050,241;33;F
49466;227,1050,1718,230,232,656,1305,1275,652,214,228,231,1254,241,528;40;M
49475;1254,227,232,1050,228,1305,230,214,528;60;M
49645;241,1050,1254,230,227,232,214,528,1305;59;F
49759;1254,1275,1305,232,1050,566,652,214,1051,230,528,656,231,241,228;44;M
49888;241,214,656,528,1305,1050;42;M
50014;652,1275,228,1718,528,1305,1050,227,1051,656,230,214,232,231,241;27;F
50095;227,528,656,228,566,1275;27;F
50166;566,1051,1050,241,1718,230,214,528,1275,231,228,232,656,652,1305;34;F
50241;241,231,228,528,214;48;F
50374;1305,231,1051,230,241,652,566,528,214;41;F
50401;528,214;70;F
50471;652,1050,241,231,228,232,214,528;41;F
50479;241;40;F
50496;241,656,1254,1718,231,228,652,1305;34;F
50519;656,231,241,566,658,1275,1051,227,232,230,652,1305,528,228,214;41;F
50532;528,1254,1050,1718,230,232,214,1305,1275,241,227,231,228,656,652;38;F
50771;214;45;F
51058;566,231,1050,1254,1718,230,227,1051,228,214,656,528,652,1305,1275;32;F
51085;566,658,1718,230,227,231,1051,228,232,214,656,652,1305,1275,241;45;F
51151;1050,1254,1718,231,228,232,656,652,658,528,1305,241,230,1275,214;34;F
51252;232;33;F
51283;214,241,1718,230,227,231,1051,228,232,652,566,658,528,1305,1275;18;M
51285;230,227,214,566,528;22;F
51344;1050,230,227,566,528,214;69;F
51390;214,566;15;F
52299;1050,241,1718,230,227,231,228,214,656,652,528,1305,1275;45;F
52547;1275,1305,227,1050,230,228,566,528,656;56;F
52584;1275,528,652,214,231,227,1718,1254,1050,241,230,1051,228,232,656;47;M
52794;1305,1050,241,214;44;F
52830;230,231,228,214,656,1275,528;66;F
52904;528,1050;42;M
53232;656,228,230,241,231;51;M
53332;1051,227,230,1718,1050,241,231,656,652,658,1275,228,214,528,1305;43;F
53376;241,1051,228,232,214,656,528;42;F
53411;230,214;36;M
53490;1050;7;M
53558;1051,228,241,231,214,528,1275;16;M
53650;658,231,227,1050,1718,656,1275,1305,566,652,241,230,228,214,528;20;F
53684;214;47;M
53698;1254,241,232,1305,656,1718,652,231,228,566,1275;21;M
53789;1275,1305,231,228,656,528,1254,214;67;F
53824;1051,231,1718,1275;45;M
53906;214,528;70;F
54087;658,230,1050,1718,1305,1051,241,232,231,228,214,656,652,528,1275;44;M
54101;1275,1305,1718,1254,214,228,1051,231,230,656,652,566,658,241,232;41;F
54107;1050,1718,230,656,1254,1051,228,232,566,241,231,214,528;56;F
54171;231,656,566,230,228,232,241,1275,652,1305,658;53;F
54248;1051,1050,1254,1718,214,656,652,566,658,528,1305,241,231,228,232;37;M
54254;1051,658,1718,1050,241,1254,231,228,232,214,656,652,566,528,1305;34;F
54591;1254,1718,241,1275,1305,658,652,228,232,231,227,656,566,214,528;22;M
54626;656,658,652;34;M
54629;227,1254,528;38;F
54693;528,241,231,228,232,214,656,652,1275;32;M
54696;1718,227,231,228,1275,652,214,241;32;F
54802;1718,230,231,214;44;M
54823;230,1051,228,1305,658,214,1050,241,231,232,656,652,566,528,1275;43;F
54853;231,228,232,214,528;33;F
54963;1254,231,214,528,1305;54;F
55026;1050,241,1718,230,227,231,228,232,214,656,652,1275,1051,658,1305;16;M
55197;1275,230,214;72;F
55337;241,231,228;44;M
55338;214,528;46;F
55352;656,214,528,1305;55;F
55403;566,241,227,214,528;46;F
55415;1275,241,231,228,232;41;M
55524;214,528,231,228;51;F
55614;1275,1305,528,652,656,214,232,228,231,1050;36;F
55995;241,656,1305;46;F
56143;1305,1275,232,656;42;M
56167;232,1051,230,1050,1718,1254,241,227,231,228,214,656,652,528,1275;39;M
56175;656,214,528;69;F
56297;656,652,658;69;F
56505;1718,228,227,231,214,528,1305,1275,1050,1254,230,1051,656,652,566;58;F
56559;241,230,228,656,1275,652;31;F
56875;1718,230,231,228,652,566,1275;26;M
57036;1050;9;F
57078;230,227,1051,232,214,566,658,528,241,231,228,656,652,1305,1050;40;F
57121;231,1050,241,230,228;31;F
57129;1050;40;F
57136;241,528,214;43;F
57138;231,566,214,528;27;F
57140;1050;41;M
57241;1051,230,1254,1275,1305,528,652,656,214,232,228,231,227,241,1050;39;F
57313;1050,241,231,228,656,1305;38;M
57401;1050;40;F
57434;227,228,214,232,241,1050,656,652,528,1305;40;F
57492;241,230,656,1305,1050;47;M
57809;566,656,214,1051,230,1050,231,227,1718,241,1305,1275,228,232,652;39;F
57882;231,241,227;40;F
57902;232,214,656,652,241,231,228,528,1275;46;F
57905;528,652,214,241,231,228,656;33;F
58008;1718,228,1275,241,231;32;M
58209;1050,227,231;40;F
58267;230,1050,1254,1275,1305,528,1718,231,228,232,656,652,566,241,214;32;M
58362;1254,230,241,227,231,1051,228,232,214,656,652,566,1305,1275,528;44;F
58433;656,1050,241,1254,230,228,232;47;F
58549;241,231,1050,1254,228,232,656,652,1305;10;F
58730;656,231,228,214,652,528,241;30;F
58744;241,1254,1051,231,228,232,656,652,1305,1275,1050,230,214,566,528;42;F
58759;230,652,1305,1275,528,658,656,566,214,1051,228,231,1254,1050;12;F
58771;1275,232,228,1718,214,1051,231,230,241,1050,656,652,658,528,1305;37;M
58777;1718,1254,230,1051,231,228,232,214,656,652,566,658,1275,1305,528;10;M
58783;230,1254,241,1050,231,1051,232,214,656,652,566,658,528,1305,1275;43;M
58962;1051,214,228,528,652,231,1254,227,230,241,1050,232,656,1305,1275;32;M
58982;566,656,231,1718;27;M
59023;656,652,1305,1050,214,241,232,528;35;M
59026;1050;45;M
59029;1254,1305,1275;69;F
59042;658,1051,1718,227,230,241,1275,1305,652,656,214,228,232,231,1254;43;F
59052;230,231,652,228;50;M
59143;241,1718,227,228,214,566,658,1275;38;M
59176;1051,1305,1050,241,230,231,214,1275;60;F
59217;1305,228,241,230,231,232,214,528;47;M
59221;1305,231,230,214,241,228,1050,528;38;F
59240;566,658,227,1051,230,1050,241,232,656,1275,1718,231,228,652,1305;46;F
59243;528,214;67;F
59298;227,1275,1305,658,566,652,656,232,228,1051,231,230,1718,241,1050;72;F
59300;1050,241,1718,230,227,231,1051,228,232,656,652,566,658,1305,1275;42;M
59301;1050,241,1718,230,227,231,1051,228,232,656,652,566,658,1305,1275;2;M
59389;1050,1718,230,231,1051,656,658,214,1305,528;49;F
59435;528,241,214,228,1050;45;M
59514;652,1275,528,1305,566,656,214,232,228,231,227,230,241,1051,1050;39;F
59529;528,214;61;F
59606;1050,232,652,230,231,228;53;F
59692;1275,656,227,230,1051,214,652,528,1305,1050;31;M
59705;1050;45;F
59927;231,228,656,652;18;F
59929;656,652,1305,1275,214,232,241,230,231,228;26;M
59979;566,528,214;18;M
59989;1718,658,228,241,1050,1254,214,566,528,1275,1305,227;55;M
60041;1275,1305,652,231,1718,1051,228;41;M
60115;214;54;F
60283;227,232,656,230,1718,1051,652,566,658,1305,1275,1050,241,231,228;42;M
60395;241,227,231,214;48;F
60436;652,1254,1718,528,214,656,227,1050,230,1305,232,228;25;M
60458;1050,656;35;F
60485;1254,230,231,214,656,652,1305,1275;64;F
60540;214,528;7;F
60580;1254,1305,1275;12;F
60630;1254,1305,1275;12;M
60679;658,232,241,1050,1254,230,214,656,566,528,228,1275,1305,652,1051;27;M
60891;1254,1051,566,1718,227,1305,1050,241,228,232,214,656,652,528,231;40;M
60972;228,1718;36;F
60980;232,1050,658,230,1718,1051,241,528,656,1275,214,1305,652,228,231;45;F
61064;1305,528,214,230,228,652,656,1275;49;F
61114;1051,232,1050,241,227,1275,1718,231,228,214,656,652,566,528,1305;13;F
61222;232,214,528;46;F
61240;214,1051;49;F
61257;241,1718,230,227,231,1051,228,232,214,656,652,566,528,1305,1275;46;F
61370;241,231,228,1305,528,652,214,656;56;F
61373;652,566,228,230,241,231;33;M
61539;241,1254,230,228,232,214,656,528,1305,1275;47;F
61560;1718,231,232,214,658,1305,1275,656,652,528,241,230,227,1051,228;42;F
61606;1275,230,241,231,228,214,656,566,528,1305;29;F
61735;232,214,1051,1050;40;F
61813;232,1050,1051,656,1718,230,241,1254,231,228,214,652,528,1305,1275;50;F
61913;1254;52;F
61966;1305,528,566;43;F
61987;1050,1718,1275,1305,227;45;F
62286;231,228,652,1718;38;M
62304;528,652,214,232,228,1050,1305,1254,241,227,1275;35;F
62336;214,232,230,1254,1050,656,228,227,241,231,652,528,1275,1305;45;F
62355;241,231,228,652;43;F
62368;656,214,228,231,241,652;46;F
62379;241,227,231,656,652,566,528,1305;46;F
62539;241,231;52;F
62603;241,1254,1718,230,231,1051,228,232,214,656,652,566,528,1305,1275;47;F
62759;1305,656,241,231,228,232,652,1275;39;M
62795;528,230,231,1051,1275;75;M
62882;566,528,1305,241,230,231,228,214,656,652;46;F
62898;656,241,1275,1305,228,231,1718,652;35;M
62957;214,232,230,227,652,566,658,528,1275;50;F
63018;566,230,227,231,228,232,652,1254,241,1051,1275,658,656,214,528;16;F
63642;231,228,656,652,1305;38;M
63812;528,1305,241,227,231;43;F
63831;658,528,1305,1275,241,232,656;41;F
63889;214,1305,228,1050,241,231,232;35;F
63894;1275,652,1718,231,228;38;F
64174;1275,232,228,227,231,652,214,528;46;F
64186;1050,1051,656,566,658,230,1718,227,231,228,232,652,1305,1275,241;40;F
64202;231,232,528,1050,241,566,658,1254,230,227,228,656,652,1305,1275;46;F
64204;528,214;45;M
64240;214,528;10;F
64278;227,231,228,232,214,652,528,1305;9;M
64282;1305,656,652,214,1051,230,241,1050,231,228,528,1275;39;F
64375;1254,1305,1275;35;F
64424;566,1254,1051,1050,241,230,231,228,232,214,652,656,1275,1305,528;35;F
64439;1718,230,227,231,1051,228,232,1305,528,658,566,652,656,214,1275;19;M
64559;231,1275,658,1051,1305,232,228,1718,1050,241,214,656,652,230,528;44;F
64919;214,1275,528,227,1050,1718,1051,228,658,1305,230,656,652,231,241;68;F
64927;1275,228,656,652;59;F
64973;1254,228,214,652,528,656,231,241;55;F
65004;232,1305,241,1050,230,227,1051,1254,231,228,656,214,652,528,1275;41;F
65012;228,1050,231,230,656,652,1305,1275;47;M
65078;656,228,658,528,1305,1275;38;F
65270;1050,1254,1718,1305,1275;68;F
65345;214,227,232,1051,230,1718,1050,658,228,656,652,1275,231,241,1305;36;F
65466;232,656,652,1305,241,231,228;42;M
65470;656,1718,227,652,1275,1305,241,228;37;F
65494;227,228,1305;37;F
65505;228,227,1051,652,656,1275,658,1050,1718,230,232,214,1305,528,566;43;M
65651;227,1275,1305,228,214,528;42;F
65660;1050,241,227,1051,228,214,656,528;38;F
65694;232,227,241,1050;40;F
65723;1275,232,227,241,1050;12;M
65741;1050,241,227,232,1275;45;M
65759;1050,241,227,232,1275;10;M
65786;528,214;24;M
65813;1305,652,228,658,1275,232,1051,231,227,230,241,1050;43;F
65928;1051,1050,241,1254,230,227,231,228,232,214,656,652,566,528,1305;42;F
65968;232,652,656,1050,231,1305,241;44;F
66133;230,1275,1305,652,656,228,231;40;M
66167;241,227,231,232,656,1254,1305,1275;27;F
66237;231,1718,652,566,658,528,1305,1275,241,1050,227,230,1051,232,214;39;M
66377;241,227,231;43;F
66424;214,1050,230,227,652,528;49;F
66529;230,214,528;42;F
66677;1254,652,232,1718,231,228,214,656,528,1275;67;F
66869;528,656,214;67;F
66908;227,652,228,241,231,1718;34;M
67009;1050,230,214,652,528;7;M
67010;1050,241,231;44;F
67018;1051,528,214,227,230,656,1275,232,241,1254,1718,231,228,652,1305;36;F
67168;656,1051,241,1050,230,231,232,652;40;M
67237;214,232,228,1254;32;M
67499;232,1050,1254,241,230,227,214,528,656,1275,1718,231,228,652,1305;33;F
67750;652,228;38;F
67936;214;68;F
68057;227,231,232,652,1275;34;M
68058;1050,1254,1718,1305,1275;44;M
68097;214,1275,227,528,230,1051,1305;28;F
68111;1254,1718,228,232,214,652,656,1275,1305,566,227,231,528;31;F
68126;241,1254,1718,230,227,231,1051,228,232,656,652,566,658,1305,1275;59;F
68165;1051,230,1305,1275,658,652,231,1718,241,1254,227,228,214,566,528;32;F
68242;241,1718,227,231,1051,228,232,214,656,652,566,658,528,1305;29;M
68318;1254,658,1305;44;F
68437;528,241,230,227,1051,228,656,658,1305,1275,652,1254,231,232,214;29;F
68486;241,656;51;M
68521;1051,228,214,528;40;F
68575;214,1718,1254,1050,1305,232,228,1051,230,227,656,652,566,658,1275;31;F
68714;1050,1254,1718,1305,1275;67;F
68733;214,1254,658,528,1305;43;F
68744;566,1275,241,231,228,214,652;44;M
68807;652,231,241,228,214,528;50;M
68974;1050,241,230,232,214,656,528;32;F
69015;1718,231,228,232,214,656,652,528;29;M
69017;214,656,1275;39;F
69158;656,228,1254;39;F
69203;214,1718,1051,241,1254,232,1305,1050,652,656,228,231,227,230,1275;52;F
69207;227,231,228,232,214,652,528,1275;64;M
69403;241,231,214,656,1305,1275,1254;42;F
69516;241,1254,231,214,656,652,528,1305;29;F
69601;1275,1305,528,214,232,228,231,1050,656,1254,652;43;F
69701;230,566,1275,1050,1254,228,656,652,658;43;M
69741;231,228;43;M
69751;214,652,1305,528,230,228,1275;41;F
69798;227,231,228,214,652,658,241,1254,656,1305,1275;43;F
69843;228,1275,656,658,652;44;M
69844;227,231,232,1305,1718,228,214,656,652,658,528,1275;34;M
69857;566,528,227,214,1275,1051,1254,230,1050,232,656,658,241,231,228;36;F
69909;241,228,656,231;48;M
70025;1050,232,241,230,227,214,566,658,528,1305;26;F
70044;230,228,214,656,652,1275,241,1254,227,231;41;F
70152;231,1718,230,227,566,214,528,228,232,658,1305,1254,656,652,1275;59;F
70299;1050,241,1254,231,228,232,214,656,566,528;40;M
70324;566,232,658,241,1305,1050,1718,230,528,1275,231,228,214,656,652;38;F
70425;241,231,214,528,1275;32;M
70652;528,214;65;M
70720;1050,231,230,656,1275;51;F
70745;214,528;40;F
70823;1050,232,231,230,227,1718,1254,241,228,214,656,566,1275,528,1305;41;F
70868;528,230,1050,1718,227,1051,232,214,658,1275,241,231,228,656,652;38;F
70914;231,1254,1305,1275;47;F
70999;1718,231,1051,232,214,656,652,566,658,1305,230,227,228,1275,528;44;F
71025;231,1051,228,232,652,658,1275,566,241,1718,227,214,656,528,1305;44;F
71077;230,1050,658,1275,1305,232,241,231,228,656,652;43;M
71164;1050,241,1254,230,231,1051,228,232;50;M
71379;1275,658,652,230,231,228,656,566,227,1050,241,232,214,528,1305;48;F
71420;1718,1050,241,1254,1051,528,230,566,214,227,231,228,232,656,1275;63;M
71633;228,528,1275;31;F
71747;656,232,228,231,1050,241,230,1051,214,528,227,1718,1254,1275,1305;47;F
71761;566,214,227,656,1050,241,1254,1718,230,231,1051,228,232,652,1305;54;F
71857;232,1051,231,227,1050,241,1718,230,656,658,1305,228,214,528,1275;37;F
71914;1254,232,1275;24;M
71945;1051,658,1305,1050,1718,230,231,232,656,1275,241,228,214,652,528;36;F
72028;656,231,1718,566,1305;40;F
72068;241,1050,214,566,528;7;M
72075;241,227,232,566,528,214;34;F
72107;1275,230,658,528,652,656,1051,566,228,231,1050,214,227,232,241;45;M
72138;652,1305,1718,231,228;56;F
72148;528,214,1050;37;F
72174;1275,1305,656,1718,566,232,1254,228,227,1051,214,528;36;F
72201;227,228,232,214,1305,528;6;M
72228;1050,1305,656,1051,230,228,528,214;34;M
72240;1254,241,228,232,214,656,566,658,528;2;M
72258;1051,232,241,1050,231,228,652;42;F
72459;1254,1050,1718,230,227,228,232,214,656,652,566,658,1275,231,241;39;M
72466;566,1305,1275,214,528;34;M
72590;1254;43;F
72629;228,232,652,1275,658,1305;48;F
72745;241,230,227,656,214,528,1718,231,228,652;52;F
72769;231,214,652,1305;34;F
72784;232,1275,1305,1718,227,230,1050,566,528,241,231,228,652,214,656;45;F
72786;1050,241,230,231,1051,228,214,566,528,1275;43;M
72861;656,1305,1275;67;F
72871;1050,230,232,1275,1051,656,1718,652,1305,241,227,231,228;47;M
72895;241,227,231,228,652,1305;37;M
72963;230,231,1050,241,214,528;40;M
73058;1050,227,214,1305,656,228,231,241;40;M
73059;228,1051,1718,1275,1305,528,566,652,231,227,656,214;34;F
73091;652,656,1305,1275,1050,241,230,1051,214;37;F
73125;230,231,656,1305,528,214,228,1050,241;39;M
73149;230,231,241,228,214,652;34;F
73166;231,228,528,214;20;M
73319;528,652,214,232,228,230,1050,241,231;39;M
73321;1254,227,214,528;73;F
73352;228,656,1305,1275;51;M
73410;1051,214,232,230,566;33;M
73473;214,241,528,231,228,652,1275;39;F
73480;231,1305,228,1050,241,227,656,566,1275,658,214,1254,230,1051,528;38;F
73493;241,231,228,656,652,566,1305;38;M
73505;241,228,214,528,1305;55;F
73522;1254;75;F
73553;1254,232,566,1275,1050,241,230,231,228,214,656,652,528,1305;44;F
73602;656,652;42;F
73632;241,227,231,652,1305;46;F
73676;241,214,566,1275;40;F
73743;528,232,227,1050,1254,1718,230,231,228,656,652,658,1305,1275;9;F
73752;1275,1305,652,231,230,228;24;M
73769;1254,1050,1275,214,1718,230,1051,232,658,1305,241,231,228,656,652;52;F
73771;656,227,1254,241,1275;47;F
73908;230,528,1050,241,214;47;F
73923;1305,1275;48;F
74070;1254,1718,230,227,231,228,232,658,1275,652,656,566,528,1305,214;15;M
74188;230,231,228,1305;39;M
74202;528,656,227,214,1718,1051,1305,1275,230,652,232,228,231,1050,241;37;M
74220;1050,1254,1718,1051,658,1275,1305,241,230,231,228,232,656,652;33;M
74221;227,231,228,214,528;55;M
74261;230,528,1305,232,652,656,1275,227,241,1051,231,228,566;37;M
74264;652,1254,231,1051,656,658,1050,241,230,227,228,232,214,528,1305;45;M
74351;1050,230,1051,232,656,658,1305,1275,1718,231,228,652,241;38;M
74506;241,1718,227,231,228,656,652,566,1305;26;F
74571;528,658,1718,231,1051,232,1050,241,230,228,652,656,1305,214,1275;44;F
74580;241,230,227,231,1051,228,232,566;41;F
74607;228,656;33;M
74618;1051,228,566,227,241;44;F
74669;227,231,1051,228,232,214,566,658,528,1305,1275,652,656,230,241;35;M
74734;1050,241,1718,230,227,231,1051,228,232,214,656,652,528,1305,1275;37;F
74770;230,241,214;44;F
74782;1050,241,1718,230,227,231,1051,228,232,214,656,652,528,1305,1275;9;F
74804;1050,241,1718,230,227,231,1051,228,232,214,656,652,528,1305,1275;7;F
74947;1275,528,652,241,1254,231,228,214,1305;37;F
75120;1254,1051,232,228,231,230,241;39;M
75207;231,228,214,528,1305;54;F
75211;241,227,231,228,652;49;F
75298;1050,1254,214,566,1305,528;34;F
75451;566,658,528,1305,1275,231,228,232,656,652;30;F
75458;1275,232,656,652,228,231,241,1050;39;M
75513;1254,1718,230,227,1051,214,1275,528,658,1050,241,231,228,656,652;45;F
75587;228;37;M
75682;1050,1718,231,228,214,528;49;F
75878;656,652,658;44;F
75903;1718,230,227,231,228,214,652,566,658,528,1305,241,1050,232,1051;41;F
75929;1718,214,566,232,652,656,658;30;F
75930;230,656,652,658;30;F
75989;658,241,1718,232,656,652,1275,231,227,1050,230,228,1305,214,528;50;F
76022;230,227,214,656,652,658,528;30;M
76105;214;21;F
76192;214;74;F
76404;1718,1051,652,658,232,231,1050,241,230,228,656,1275,1305,214,528;38;F
76466;1305,214,528;36;M
76524;230,227,1050,241,231,1051,228,232;43;F
76540;1050,1718,230,228,232,656,652,241,231,214,528;42;F
76586;1051,230,227,231,228,214,528;38;F
76778;566,1718,241,1050,214,656,528,1275,230,231,1051,652,1305,227,228;42;F
76935;1305,528,230,652,656,658;18;M
76940;528,214;41;F
76979;232,241,230,656;42;F
77034;214,656,652,528;41;M
77049;1254,214;40;F
77103;566,241,232,214,1305,228,231,227,230,1050,528,1718,656,1275,652;49;F
77127;1718,656,652,658;63;F
77149;1254,231,228,656,652,1275;31;F
77196;1254,230,227,1050,231,656,652,1305,1275;38;M
77236;1718,227,231,228,652,1275,656;47;M
77340;1718,231,228,656,652,1275,230,214,528;18;F
77387;1254,214,658,566,1050,241,230,227,1051,232,228,1718,231,656,652;35;F
77478;528,232,566,1051,230,1305,1275,1718,241,227,231,228,656,652,658;41;F
77534;214,528;71;F
77592;652,656,228,231,241,1254,1305,1275;12;M
77640;231,214,656,1254,1305,1275;46;M
77698;1305,231,228,566,528;63;M
77808;528,214;74;F
78003;228,1275;34;F
78163;528,228,241,214;40;M
78207;1254,1050,1051,232,214,528,241,1718,230,231,228,656,652,1305,1275;42;M
78250;214,656,652,566,528,1050,1254,1718,1305;33;F
78267;241,231,228,232,214,656,652,528;40;M
78403;241,1050,1254,230,227,231,1051,232,214,656,652,566,658,1305,1275;42;F
78460;1254,1050,228,1275,656,652,658,230,231,227,1718,241,214,1305,528;37;F
78503;1275,1305,214,1718,1050,652,656,232,228,231,241;32;M
78529;231,656,1305,652,228,214,528;23;F
78535;1718,230,227,231,1051,228,232,214,656,652,566,658,528,1305,1275;39;M
78544;214,528,656,228,652,1305,231;59;F
78616;566,658,1718,652,1275,1305,241,1254,230,231,228,232,656,214,1051;19;M
78685;1275,1305,231,1050,1718,656,652,232,1051,228,227,230,241,214,528;44;F
78745;1275,1305,228,1051,227,1718,241,1254;49;M
78819;1050,241,230,231,228,214,652,528;34;M
79001;1050,1275,1051,230,1718,241,214,656,566,1305,231,228,232,652,528;42;M
79022;241,228,652,214,528,1305;44;M
79038;227,1051,214,528,1718,658,1254,1050,230,231,228,656,652,1305,1275;56;F
79103;1718,656,1254,231,228,652,658,230,227,1051,214,566,528,1305,1275;46;F
79132;656,241,1050;40;F
79312;227,231,1051,228,214,652,528,1305;44;M
79321;1050,1718,230,227,231,228,656,652,566,658,528,1305,1275,1254,214;43;F
79391;566,232,528,1275,230,1051,1305,658,652,656,214,228,227,1050,241;35;F
79414;1050,1254,1718,230,227,231,228,232,214,656,652,566,528,1305,1275;47;M
79469;528,227;63;M
79757;1275,652,656,231,230,241,1050,227,214,528,1305;38;F
79808;232,1275,656,528,214,227,241;44;F
79825;1254,230,214,1305,1275;42;F
79846;241,1254,230,227,231,1051,232,656,566,658,1275,1305,528,1050,214;36;F
79898;1254,231,1051,656,652,566,658,1050,241,230,232,214,528,1305,1275;7;M
79900;1275,528,658,652,656,232,228,1051,231,230,1718,241,214,1305;47;M
79908;1254,230,656,652,1275;42;F
79959;1718,656,1254,241,1050,230,1051,232,214,652,566,658,528,1305,1275;5;M
79980;566,656,1050,241,1718,230,231,1051,232,214,652,658,528,1305,1275;3;M
79995;214,231,230,227;47;F
80001;231,228,232,214,656,528,241;44;F
80003;231,566,1718,1050,241,230,1051,232,214,656,652,658,528,1305,1275;1;M
80166;566,528,1254;73;F
80167;656,227,1050,241,1305,658,1051,1718,1254,230,231,228,232,652,1275;19;F
80244;230,1051,1305,652,656;39;M
80263;241;47;M
80287;658,528,566,214,227,1718,1050,1254,231,228,652,1305,656,241,230;42;F
80289;1050,1254,1718,1305,1275;82;M
80448;1050,214,232,528,1275,652,228,1051,231,227,241;32;M
80579;241,1050,1254,232,214,658,1275,1718,231,1051,228,656,652,528,1305;42;F
80700;528,1050,1051,230,1718,232,652,658,1305,227,228,656,241,231,1275;48;M
80715;1050,1254,1718,228,658,230,1275,231,227,241,1305,214,656,652,528;35;F
80801;214,528;35;M
81138;231,1718,1254,1050,230,227,1051,232,214,656,652,566,528,1305,1275;35;F
81164;656,652,528,1305,241,230,231,228,214;42;M
81258;528,656,228,1305,214;34;M
81274;1275,214,230,1254,231,228,652;33;F
81288;528,566,241,1305,231,228,656,652,1275;32;M
81346;230,652,656,1275;43;M
81376;228,231,1305;42;M
81607;1254;46;M
81715;1718,214,528,1050,230,231,228,652;40;M
81741;1050,230,214,656,241,228,1305,652;38;F
81939;1275,658,652,656,1718,241,231,228;40;F
82021;528,227,230,1718,241,231,232,228,214,656,652,1275,1305;33;F
82048;1718,232,656,231,228,652,1305,1275;44;M
82083;214,1275;35;M
82122;1051,1050,230,656,232,241,528,1305,1275,1718,231,228,214,652;51;F
82126;1050,214,1305,1275;74;F
82233;227,214,656,652,528,1275;41;F
82421;1050,232,656,1305,214,241;36;F
82479;230;18;F
82484;1718,1050,230,566,1275;42;M
82522;658,566,528,1254,227,232,214,241,1718,231,228,656,652,1305,1275;42;F
82648;241,231,656;41;F
82656;1275,1305,652,656,228,1051,227,230;42;F
82706;241,230,227,231,1051,228,232;48;M
82810;1275,1305,528,566,652,656,214,228,231,230,1718,1050;33;F
82822;241,230,1051,228,232,1050,231;49;F
82894;656,652,1718,228,232,214,566,528,1305,1275,1050,241,230,227,231;46;F
82916;528,566,230;22;F
83002;566,1254,228,656,1305,227,231,232,214,528,241,1050;39;M
83003;214,528,1275;40;M
83019;214,228,232,241;37;M
83158;1254,228;55;F
83216;214;53;M
83245;227,241,528,1718,652,1305,1275,228,231,656;31;M
83307;231,528,1275,241,228,214;26;F
83324;241,528;36;F
83429;1050,241,230,231,1051,228,232;14;F
83431;1305,528,656,214,1050;35;F
83823;1718,231,228,656,652;49;F
83863;214,656,528,1275,231,228,652;58;F
83890;214,528;23;M
83947;1718,230,227,231,232,1051,228,652,566,528,1305,1275,241,656;25;F
83992;1050,1254,227,232,656,652,658,1275,566,228,241,231,214,528,1305;40;F
84000;232,241,1718,230,227,231,228,214,656,652,566,658,528,1305,1275;37;M
84055;214,528;63;F
84101;227,231,1051,566,1275,214,232,528,1050,1254,241,228,656,652,1305;71;F
84205;228,1050,1254,1718,1305,1275;46;F
84211;214,528,1305;68;M
84215;528,214;77;M
84265;1254,228,528,1305,214;42;F
84276;241,227,231,656,652,566,1275;40;F
84305;1718,230;33;M
84361;214,528;78;F
84362;231,228,232,656,652,241;36;F
84404;1275,1305,652,656,228,231,230,241,1050;42;M
84410;658,214,528,1305,1275,1718,230,1051,228,232,652,1050,241,231,656;35;M
84423;214,656,652,566,528,1305,1051,231,227,230,1050,1254,241;39;F
84556;1305,1718,1051,528,214,1275,652,566,230,231,656,228,1050,232,241;43;M
84614;1050,528,1718,1051,1305,232,652,658,1275,230,228,214,656,231,241;38;M
84615;1718,1275,1305,241,231;42;F
84632;230,231,656,658,1305,652,1275,228;60;M
84675;566,1305,241,231,228;35;F
84679;230,227,528,228,232,1051,214,566;47;M
84771;228;44;M
84785;566,231,227,652,656,241,214,528;75;F
84934;1051,228,231,241,230,214,528;38;M
85010;1718,566,241,528,232,658,652,656,228,1051,231,227,230,1305,1275;41;F
85020;1254,658,1718,1275,652,231,656,1305,528,232,228,230,1050,214,241;50;M
85106;228,214,656,566,528,1305,241,231,652;34;F
85122;1275,1305,528,566,652,656,214,228,1051,231,227,1718;15;F
85225;566,528,241,1254,230,658,1050,1051,1718,656,652,1305,1275,231,228;43;F
85322;1305,1254,241,231,228,230,214;17;F
85333;1050,241,230,214,528,1275;28;F
85376;1050,652,1305;38;F
85413;1305,1050,241,1254,1718,230,227,231,228,214,652,566,528,1275;53;F
85462;658,232,230,1275,1305,652,656,1050,241,231,228;49;F
85463;1050,231,528,1275,1305,227,228,656,652;58;F
85524;241,1718,230,1051,214,528;68;F
85696;1305,566,652,214,228,230,656,1275;44;F
85772;241,1718,230,231,652,1305,228;46;M
85820;241,214,652,528,1275;45;F
85882;231,528,214,228,227,1050,241,1254,1305;42;F
85884;241,231,228,214,528,1275;41;F
85921;1718,652,227,1050,658,566,1305,528,232,230,241,228,231,1051,214;32;F
85935;230,656,1275,528,566,214,232,1051,227,1305,1050,1254;44;F
85938;214,528,1305,1718,227,231,228,656,1275,652;49;M
85997;1275,1305,658,652,656,228,231,230,241,214;25;F
86055;1050,241,1718,227,231,228,656,652,1305;72;F
86060;231,1050,1718,230,227,214,566,528,1254,1051,228,656,652,658,1275;46;F
86127;228;60;F
86171;232,1305,1275,1050,230,227,1051,656,214,652,528;68;F
86206;228,1275,230,652,1305,214,1051,1050,241,231,232,656,528,227,566;38;F
86212;241,1254,656,652,566;27;F
86264;230,214,528;49;F
86301;1275,228,1718,231,652,528,214;51;M
86318;232,231,230,228,656,652,1275;59;M
86365;227,1051,232,652,528,656,214,231,230,241;55;F
86572;231,214,528,1305,228;44;F
86677;1718,230,656,652,1305,228,231,528,214,1275;40;F
86690;1718,566,1050,232,656,652,528,658,1275,1305,241,230,231,1051,228;42;F
86705;652,528,230,228,1051,1254,1050,566,214,232,231,227,241;43;F
86776;227,1051,656,232,1050,241,228,214,528;38;M
86808;1050,1254,1718,1305;66;F
86993;656,652,231,1051,228,1275;35;M
87153;228,656,652,1275;39;M
87181;1051,1718,228,652,1050,241,230,231,232,214,656,658,528,1305,1275;43;M
87306;232,1275,228,231,1051,652,656;40;M
87315;528,214,1051,231,241,1050;39;F
87374;241,231,228,656,652,1275;37;M
87378;1305,214;45;M
87519;227,1050,1718,1051,656,652,658,528,1305,231,1254,230,228,232,1275;38;F
87548;528,1305,230,227,231,228,232,566,1050,241;50;F
87563;214;51;F
87688;228,1275;54;M
87733;1051,228;50;F
87785;656,1254,1050,241,566,1275,230,1718,1051,228,232,214,227,1305,231;31;M
87790;241,228,214,528,1305;52;F
87803;214;53;M
87829;228;51;M
87868;230,227,241,1254,231,228,656,1305,214,566,528,1050,652;44;F
87907;227,214,528;68;M
87917;228;52;F
87953;652,230,1254,241,231,232,656;37;F
87977;1275,566,528,1305;47;M
88054;214,528,227,1050,232,652,658,230,1718,231,1275,1305,228,656,241;39;M
88099;1305,231,656,214,241,228,528;39;M
88167;214,656,652,658,528,1305,1275,232,1051,230,1718,1050,231,228,241;45;M
88184;227,214,528,1305,1275;47;F
88198;1718,230,228,656,652,1275,231;20;F
88257;228,231,1275,658,652,656,227,1718,1050,241,1254,214,566,528,1305;47;M
88271;1050,241,1718,230,227,231,228,232,214,656,652,658,528,1305,1275;36;F
88328;231,1051,214,658,528,566,652,656,228,1254,1050,1305,230,227,1275;39;F
88339;232,214,652,241,1051,656,528,228,1305,227;43;F
88371;232,1275,1305,230,652,528,656,228,231,241,1254,214;64;F
88373;528,230,1718,241,1050,231,1254,228,214,656,652,658;40;F
88379;227,232,214,652,658,1275,1050,241,230,231,228,656,1305;42;F
88388;528,658,228,1051,231,1718,1275,1305,1050,230,227,232,214,656,652;33;F
88412;214;40;M
88423;1051,230,1050,241,232,214;34;F
88439;214,1275,528,227,1718,1305,230,1051,1050,228,652,241,231,656,232;49;M
88467;241,1718,230,227,232,214,566,658,528,1305,231,228,1275,652,656;37;M
88521;1050,230,231,228,241,214;45;F
88539;1275,1305,652,1050,241,230,231,1051,228,232;36;M
88550;1050,241,1254,1718,230,231,228,232,656,652,1275;37;F
88621;1275,1305,658,230,1718,1050,241,231,1051,228,232,652;44;M
88776;230,1050,1275,1305,656,227,1718,232,528,231,228,214,652,658,241;35;F
88896;214,231,528;31;M
88949;1305,1275,528,214,232,1051,227,230,1718,1050,241,231,228,656,652;36;M
89003;1051,230,1254,1050,228,232,656,652,566,658,1275,1305,1718,241,231;32;M
89034;231,1051,228,656,652,1305,528,1050,241,230,214;34;M
89043;1254,214,227,232,528,1718,230,656,652,566,1305,1275,241,231,228;41;M
89060;231,214,656,566,528;21;F
89086;652,656,232,228,227,231,241;40;M
89100;1718,1254,230,227,232,652,566,528,1305,1275,241,231,228,214,656;39;F
89208;656,652,658;41;F
89225;231,228,656,1275;40;M
89285;528,1254,1718,1275;71;F
89311;656,652,658;45;M
89327;228,656;36;F
89376;1275,528,658,656,228,1051,231,1050,241,1718,230,227,232,214,566;18;M
89424;241,1718,528,228,231,227,230,1254,652,656,566,1305,1275;46;F
89451;658,656,652;14;F
89532;656,652,658;72;F
89700;230,1718,1051,232,1305,1275,241,227,231,228,214,656,652,566,528;45;F
89759;232;51;F
89795;566,214,227,1718,1305,528;65;F
89910;241,228,1275;33;F
89933;1051,232,214,528;36;F
89992;230,227,231,1051,214,528;38;M
90082;658,1051,656,228,1275,1050,230,232,214,566,528,241,231;71;F
90147;1050,241,230,227,228,232,1275;42;F
90229;1718,230,232,228,1254,231,1051,528,1305,566,652,656,214,241,1050;46;F
90232;228,214,528;45;F
90238;1718,241,1050,1254,227,1305,1275;43;F
90273;566,1050,241,1718,230,231,1051,228,232,214,656,652,528,1305,1275;39;F
90336;227,566,214,231,528;79;M
90356;1254,1718,232,652,566,1050,241,231,228,214,528,1305;49;M
90365;231,230,227,214,528;44;F
90455;231,227,228,656,652,232,1305,1050,214,566,528;40;F
90655;528,1275,1050,241,230,227,231,1051,228,232,214,656,566,1305,652;42;F
90669;652,214,230,228;19;M
90766;1275,656,241,1718,227,231,228,214,652,566,528;24;M
90781;658,1718,1275,1305,1051,231,227,1254,241,228,232,214,656,652,528;43;F
90836;214,566,658,1305,528,1254,1050,241,231,1051,232,656,652,228,1275;61;F
90846;528;25;F
90898;1254,241,1051,1050,230,227,231,214,656,652,658,528,228,1305,1275;37;F
90929;1050,1254,1718,230,227,231,1051,228,214,656,652,566,528,1305,1275;11;M
90962;231,1718,1050,1254,230,227,1051,228,214,656,652,566,528,1305,1275;41;M
90980;1718,1050,1254,230,227,231,1051,228,214,656,652,566,528,1305,1275;9;M
91000;231,1050,1254,230,227,1051,228,214,656,652,658,566,528,1305,1275;6;F
91043;1718,1254,230,227,231,1051,232,656,566,658,1305,1275,241,228,652;32;M
91061;227,652,1305,1050,241,231,228,214,528;39;F
91121;1050,241,230,231,656,1305;41;M
91283;528,1050,214;37;M
91305;1050;40;F
91354;566,1718,227,232,1305,231,241,1050,656,214,1275,230,228,652,528;45;F
91359;1275,1254,230,1050,241,231,566;30;M
91370;241,230,227,214;51;M
91385;227;32;F
91607;241,231,1051,228,656,214,566,528;36;F
91704;566,652,230,1051,1050,227,228,656,214,241,231,232,528,1305,1275;42;M
91773;1254,230,228,214,656,652,566,658,528,1305,1275,1051,241,231,232;36;F
91830;241,656,652;44;F
91853;241,230,228,1305,1275,1718,227,656;29;M
92244;1275,656,652;42;M
92279;230,231,214,566,528,1305;4;F
92346;1305,241,230,231,228,214,652,566;20;M
92353;528,214;51;F
92381;214;34;F
92464;656,230,566;36;M
92485;241,214,528;44;M
92548;227,1718,658,566,656,214,230,1050,1305,1275,241,232,231,1051,228;42;F
92687;214,528,241,1050,1275,1305,652,656,228,1051,231,230,1718,1254;53;F
92734;652,656,230,1050,528,227,231,1051,228,214;44;F
92872;227,228,214,528,1305,231,232,652,241;35;F
92920;231,228,656,652,1305,1050,230,214;38;M
92971;1050,227,656,652,566,528,214;13;F
93117;232,528,214,231,1051,228,566,658,1050,230,227,1305,656,652,1275;49;F
93153;230,1050,241,231,214;36;M
93219;1050,241,1718,1051,228,232,214,528,1305,230,231,656,652,1275;44;F
93291;231,228;44;M
93293;1275,656,241,528,566;17;F
93405;214,1050,241,230,528,1305;41;F
93475;1275,1305,1050,214;39;F
93601;1254,1050,230,1051,1275,241,1718,214,656,652,528,228,232,1305,231;43;M
93609;652,528,1275,230,231,214;28;M
93636;214,232,227,231,656,652;42;M
93669;1051,214,528,656,652,230,1050,241,231,228;37;M
93869;214,232,566,658,1718,1050,528,1305,1275,656,652,228,231,230,241;43;M
93874;528,227,1050,230,1051,1305,241,231,228,214;37;F
93889;227,566,1305,1254,214,528;45;F
93975;528,231,228,214;47;M
94000;1305,528,652,228,227,1050,241,230,231;38;M
94160;1050,230,214,566,528;11;M
94187;1254,231,566,230,227,1051,232,214,656,652,658,528,1305,1050,241;65;F
94200;241,1718,231,232,652,658,1275,228,1050,230,656,1305,214,528;44;F
94290;658,1305,566,652,656,232,1051,227,230,1718,1254,1050,241,231,228;24;F
94293;1050,230,214,528,1275,1254,227;46;F
94307;1275,1305,528,652,1718,230,231,228,214;27;M
94334;1718,652,228,241,231;38;F
94336;658,1050,241,1718,230,1051,228,214,528,1305,656,231,652,1275,232;17;M
94434;241;50;M
94437;1050,241,230,214,566,1305,231,228,227,1275;31;F
94602;1254,230,232,658,1275,1305,241,231,228,656,652;37;F
94606;1051,1050,231,228,214,656,652,566,1305,241,227;42;F
94703;1050,566,241,230,232,1718,231,1051,228,656,227,214,652,1275;39;F
94704;232,230,227,1051,228;34;M
94741;1050,1254,1718,1305,1275;77;F
94777;1275,232,656,652,528,1305,241,231,228,214;49;F
94779;214,1305,528;42;F
94966;566,1718,241,1050,230,232,1305,1275,231,1051,228,656,214,652,528;14;M
94978;231,228;49;M
94985;658,528,230,1050,232,241,1718,227,231,228,214,656,652,1305,1275;29;F
94991;528,1305,652,656,232,231,227,230,1718,1254,241,1050,1051,1275,228;40;F
95089;230,232,1305,656,652,1254,214,528,1275;61;F
95103;214,228,1275,1050,1254,1718,1305;61;F
95195;1718,232,1305,231,228,652;84;F
95458;1305,566,652,231,1050,241,658,656,230;26;F
95493;652,232,228,231,656;45;M
95576;1050,230,228,232,656,652,1275;31;M
95625;1050,241,227,214,566,1305;43;F
95687;1305,241,228,656,652,1275;37;M
95752;1718,230,231,1051,566,1050,658,1305;33;F
95794;1254,1305,1275;37;F
95832;1050,230,1275,1051,227,528,566,232,1254,231,228,214,652,656,1305;64;F
95880;1050,241;50;M
95899;214,232,1051,227,230,1718,1305,528,658,652,231,241,1050,228,656;35;F
95900;566,658,528,1305,1275,227,1254,1050,241,228,1051;44;F
95936;658,1305,1254,1718,230,232,214,656,528,1275,652,228,231,241,227;44;F
96019;1275,1305,528,658,566,652,656,232,228,1051,231,227,214;43;F
96023;214,528;76;F
96130;656,228,241,652;39;M
96291;1305,658,232,228,231,241,566,528,652,656,1275;42;F
96299;228,231,227,1051,214,528;38;F
96590;1275,1305,656,228;36;F
96762;1275,658,652,656,228,241,231,230,1254,1051,1305,528,214;41;M
96850;232,1050,1305;45;F
96890;1275,1718,1050,241,1254,214,528,1305;35;F
97024;230,658,566,227,232,1275,528,1305,652,656,228,241,1718,231,214;34;F
97096;214,1718,1051;42;M
97273;228,231,241,1275;50;F
97301;1254,214,656,652,227,528,1305,1275,1050,241,230,231,228,232,566;50;M
97326;230,227,214,656,528,241,1050;35;F
97347;1275,1305,652,656,1050,230,241;33;M
97395;241,1254,227,231,214,656,652,528,1305,228;51;F
97424;227,1305,566,231,228,214,652,528;57;F
97472;232,241,1050,230,528,214;35;F
97605;1718,658,566,652,232,1051,227,241,231,214,656,528,1305,1275,228;31;F
97666;227,528,1275,228,231,230,214,656;21;F
97670;241,1275,528,566,228,231,1718,227,656,1305,652;11;M
97691;656,1051,231,1050,1275,1305,652,232,241,214,228,227,566,528;15;F
97752;1050,232,1305;38;M
97791;566,658,528,241,1718,230,227,231,1051,214,1275,1305,228,656,652;33;F
97795;241,227,228,1305,656,214,528,652;41;F
98049;241,1718,232,230,231,528,214,652,1050,1254,228,656,658,1305,1275;40;M
98213;652,241,231,228;83;F
98248;214,652,528,1050,230,1718,1254,241;54;F
98251;228,231,241,566,1305;40;F
98267;1275,214,230,1050,1718,231,228,652,528,1305;48;F
98310;214,1275,1050,241,1718,230,227,231,228,232,656,652,566,658,1305;34;M
98323;241,1254,230,228,232,214,528,1305,1275;58;F
98465;528,566,214,227,1254,1718,230,231,228,656,652,658,1305,1275;11;M
98488;241,231,214,656;44;M
98514;214,566,528,1254,1275,1305,658,232,1051,1718;30;M
98519;230,1051,1275,528,566,652,1254,227,241,1718,231,228,232,214,1305;12;F
98531;241,232,228,230,1050,1254,231,1051,528,1305,227,658,656,1275,652;21;F
98594;658,228,1718,230,241,1275,1305,656,1050,1254,227,232,214,566,528;34;F
98714;1254,227,1305;37;M
98723;227,1051,232,652,566,1050,1718,230,231,228,214,656,528,1305,1275;49;M
98811;1051,652,658,528,241,230,656,566,1305,1050,232;37;F
98817;1275,1305,656,652,214,1050,230,1718,528,232,1051,241,227,231,228;45;M
98838;231,228,232,656,652,566,1305,1254,1051;36;F
98883;1305,228,227,566,528,241,214;44;F
98969;232,228,1050,241,528,1275;32;F
98983;228,227,652,656,214,231,241,566;47;F
99057;1254,227,214,656,566,528,1305;52;F
99113;228,232,656,652,1305;36;F
99118;566,232,1051,227,230,1718,1254,1050,241,214,656,652,1305,231,228;32;F
99258;566,230,1051,652,658,1275,1305,1718,214,232,228,227,241;26;M
99293;228,652,1275;47;M
99307;214,1275,658,1050,241,1718,230,231,1051,228,232,656,652,566,1305;39;F
99363;1275,1050,241,1254,230,227,231,1051,228,232,214,656,652,528,1305;45;F
99440;1305,1275,652,656,228,1050,230;20;F
99471;231,228,656,1718;74;F
99490;1051,652,1305,1275,227,230,1254,228,241,231,232,214,656,566,528;41;M
99511;230,1051,228,656,652,1305,1275,241,1254,227,231,232,214,566,528;38;F
99603;1305,1050,241,230,528;56;F
99619;230,214,566,1051,231,227,1718,241,1050,228,656,232,652,528,1305;8;M
99669;652,658,230,227,1051,228,214,566,528,1305,1275,1050,241,231,232;40;F
99689;1050,241,230,231,228,656,652,528,214;58;F
99705;656,231,227,230,1718,1275,1305,528,658,214,232,1050,652,241,228;33;F
99732;1051,566,1305,1050,241,230,227,231,228,232,214,656,652,658,528;37;F
99786;214,1275,232,1305,241,231,228,652,656;49;M
99795;1051,241,1050,230,227,231,228,232,214,656,652,566,528,1305,1275;4;F
99797;656,214,230,241,227,231,1051,228,232,652,566,658,528;50;F
99813;1050,241,227,566,230,231,1051,228,214,656,652,528,658,1305,1275;40;F
100003;1050,241,231,228,652,1305,1275;35;M
100004;241,1050,230,227,231,1051,228,232,214,656,652,566,528,1305,1275;10;M
100023;652,227,228,231,232,241,566,1305,1275,528,658,656,230,1050,214;46;F
100038;1050,230,214,656,528,231,228,232,652,1305;63;F
100074;214,228,231,656,652,566;36;F
100077;1254,658,566,1275,1305,652,656,228,1051,231,227,230,1718,241,1050;35;M
100095;528,214;56;F
100123;652,1305,231,232,1275,214;17;F
100135;1254,1050,232,656,652,658,230,241,231,1051,228,214,528,1305,1275;5;F
100175;241,1254,227,232,656,1275,566,1305;42;F
100227;1050,1254,230,1718,214,528,1305,227,656,652,241,231,228,232,566;49;F
100279;658,231,230,1050,1275,1305,528,566,652,656,214,232,228,241,227;44;F
100341;241,231,228,656,652;49;M
100375;1718,656,652,231,228,232;49;F
100426;1275,241,227,228,652;42;M
100485;228,656,566,528,1305,1275;31;M
100502;214,528,1275;32;F
100607;230,228,1305,1275;35;F
100609;232,214,656,566,528,652,228,230,1718,1050,231,1051;37;F
100635;1050,241,1718,656,658,1275,230,227,231,1051,528;39;M
100652;241;38;F
100666;1254,230,227,1051,214,566,232;45;F
100700;566,528,232,1051,227,241,1718,231,228,656,652,1305,1275;28;F
100704;214,1718,1254,1051,656,652,658,528,1305,1275,228,230,232,231,241;23;M
100725;1718,1305,1275,241,227,231,228,214,528,656;65;F
100746;1275,658,652,1718,241,1050,566,1305,214,228,231,227,230,528,1254;40;M
100835;1718,227,228,1275,652,1305;24;M
100860;1275,1305,1051,1718,231,228,232,656,652,1050,241,230,214,528;34;F
100889;1718,1050,241,230,231,1051,228,232,214,656,652,566,528,1305,1275;37;M
100956;1305,528,241,1050,231,214;36;F
100957;241,230,1051,528,1305,566,232,231,227,1718,1050,228,656,652,1275;44;F
101087;1305,231,228,656,652;40;F
101116;214,566,658,1050,241,1718,230,231,1051,228,232,656,652,528,1275;24;F
101153;566,658,1275,241;35;M
101185;214,1718,227,232,658,1305,1275,1254,241,1050,231,1051,228,656,652;38;M
101228;241,227,566;31;F
101229;231,230,241,1275,1305,528,652,656,232,228;45;M
101245;1718,231,652,1305,230,227,1275;21;F
101343;1275,528,652,214,232,1051,230,1718,1254,1050,241,227,231,228,656;27;M
101361;652,1718,231,228;47;F
101500;652,1275;35;F
101510;214,528,1305,652,656,1051,1718,1275,241,228,231,230;53;M
101558;232,228,1051,231,227,230,1254,566,658,528,1275,214,241,1718,1305;43;F
101560;230,1718,241,227,231,1051,228,658,1305,1275;36;M
101734;227,231,228,566;31;M
101756;1275,652,228,1051,231,241,232,656;40;F
101802;228,214,528;36;M
101817;1718,230,227,231,656,566,528,1305,241,658,652,1275,228,232,214;46;M
101857;227,1050,566,528,230,1254,1718,231,232,214,656,1305,1275,228,652;37;M
101871;1254,230,231,1051,228,214,528;44;F
101944;214,227,228,232,656,652,1305;36;F
101958;1275,1305,658,652,656,228,231,241;26;F
102035;1254,227,230,1051,566,232,214,652,658,1275,1305,231,228,656,528;42;F
102080;1718,231;23;M
102084;1050,241,231,1051,228,232,656,652;33;F
102093;1254,1305,1275;46;F
102260;227,230,528,1275,1305,658,652,656,214,232,1718,241,231,228,566;40;M
102331;241,232,528,1050,1718,231,214,566,228,656,652,227,658,1305,1275;34;F
102484;658,566,228,652,232,1051,231,227,1050,241,214,656,528,1305;44;F
102520;652,214,231,1305,656,232,241,1254,1050,230,227,1051,228,566,658;13;M
102847;566,1718,656,1051,528,652,228,214,1275,1305,1254,1050,241,230,231;42;M
102928;528,658,232,230,1050,241,1254,1718,656,652,1275,1305,227,231,228;37;F
102932;1050,241,230,228,656,652,658,528,1275;40;M
102965;241,227,231,228,214,656,652,1305;32;F
103057;241,231,1305,652,228;45;F
103086;230,1305,1050,566;36;M
103268;1050,230,228,656,652,1275;38;F
103293;1050,230,228,652;50;F
103333;1050,241,230,227,231,1051,228,652,1305;43;M
103376;1254,1305,658,1050,232,214,241,528,1051,227,230,656,652,566,1275;36;F
103419;227,656,652,231,241;50;M
103427;232,1275,1050,656,227,241,230;30;F
103583;227,232,214,1275,528,566,231,1718,241,1050,230,1051,228,656,1305;36;F
103656;1718,230,227,228,232,214,656,652,658,528,1305,241,231;32;M
103750;656,1305,652;27;M
103775;652,1275,1254,241,1050,230,227,656,566,1305,1051,228,214,528;54;F
103855;652,656,1051,1718,1305,528,214,232,228,231,227,241,1275;34;M
103888;227,1305;38;F
103959;1051,652,1050,232,214,658,528,1275,241,1718,230,228,656,1305,231;37;F
104087;652,1275,228;33;F
104172;1050,241,1254,1718,227,230,231,1051,228,214,232,656,652,1305,1275;33;F
104175;227,1050,241,230,1051,232,656,1718,231,228,214,652,528,1305,1275;66;F
104306;1275,214,528;39;F
104335;656,566,1275,1305,230,652,231,228;42;F
104378;528,1305,656;46;F
104444;231,656,652;22;F
104536;228;34;F
104601;1305,214,1050,227,566;53;M
104757;227,231,1051,228,214,1305,528;11;F
104760;1275,656,1305,228,232,214,652;37;F
104808;214;22;M
104961;1050,228,214,656,231,1051,652,658,528,1275,1305,566,232,241,230;27;M
105023;228,232,566,658,1050,1254,230,214,656,652,528,1275;33;F
105084;1051,230,1050,232,241,227,658,1254,1718,231,228,656,652,1305,1275;63;F
105189;1305,1050,1718,231,1051,228,656,652,566,658,1275,241,230,214,528;39;F
105287;228,231,241;32;M
105301;1718,227,231,1051,214,656,652,528,1305,228,566,1275;49;F
105317;1718,658,1275,656,227,232,214,1305,528,1050,241,230,231,228,652;51;M
105342;230,232,214,566,1305,1050,241,1718,227,656,528,1275,231,228,652;26;F
105435;566,227,232,658,1275,1050,230,231,1051,228,214,656,652,1305,528;29;F
105563;1305,658,656,232,228,231,227,230,1718,1254,241,214,652,566,528;39;F
105625;241,1718,1305,566,227,231,228,214,528;69;F
105630;241,227,656,652,1305;41;F
105778;231,214,566,528,1305;47;M
105924;1718,230,1275,566,658;33;F
105947;1051,528,652,214,232,228,227,230,566,231,1050,1254,1718,1305,1275;22;M
106025;228,566,528,214;73;M
106077;232,566,214,228;38;F
106080;228,231,214;67;M
106249;1050,1254,1718,1305,1275;52;F
106294;1050,230,228,214,656,528;32;M
106383;230,1050,1718,231,228,656,528,1305,1275,241,652,214;36;F
106389;214;80;F
106430;241,1050,656,228;40;M
106441;1050,231,228,656,652,1305,1275;53;M
106458;658,652,656,214,232,1051,227,230,1718,1254,1050,241,231,228,1275;29;F
106504;1305,231,227,228,214,656,652,566,528,1275;35;F
106567;230,1050,227,231,228,566,528,1275,1051,232,656,652,658,1305,214;6;M
106605;656,652,528,1305,228,241;38;M
106700;241;53;M
106709;241,1718,230,227,1051,228,232,214,656,652,566,658,528,1305,1275;4;M
106735;1050,241,230,227,231,228,214,1305,528;42;M
106746;241,1254,214,528,227,231,1305;46;F
106804;1254,1305,1275;49;M
106877;1718,231,230,214,528;30;F
106942;214,528,1275;34;M
106975;214;36;F
106983;1305,1254,214,528,1275;6;F
107010;230,227,1051,658,1305,1050,1254,231,232,241,1718,228,656,652,1275;35;M
107237;1254,658,528,1305,241,227,214,656,566;37;M
107415;528,1050,241,1718,231,228,232,214,656,652,1275,1305,658,566,227;50;F
107585;1305,228;44;F
107619;1718,231,230,214,528;64;F
107627;1050,227,528,656,214,652,1275;54;M
107708;1051,230,227,231,241,566,1254,1718,228,652,214,658,528,1305,1275;36;F
107762;1718,230,231,214,528;67;M
107786;656,566,658,227,1718,1050,1254,241,231,228,232,214,652,528,1305;33;M
107801;652,656,1305,1050,241,227,231,228,232,214,566,528;41;F
107884;241,227,1275;39;F
107994;1050,1718,1051,232,214,658,652,528,1305,1275,241,230,231,228,656;35;M
108008;1275,528,214;37;M
108068;1050,241,1718,231,228,214,652,566,1305,528;39;M
108169;1051,230,231,228,656,652,658,528,241,1718,1305,1275,214,1050,1254;45;F
108170;227,231,228,214,528;41;M
108305;1275,1305,528,652,656,214,228,1051,231,227,230,241,232;35;F
108312;241,1718,1254,230,227,231,1051,228,214,652,566,658,528,1305,1275;6;F
108337;231,1275,228,214,652,528;59;M
108346;1050,1254,1718,214,528,1305,1275;42;M
108376;227,230,228,652,566,214,528;71;F
108395;528,1305,227,1254;44;M
108454;230,1718,1254,227,228,232,214,656,566,528,241,231,652,1305,1050;41;M
108494;566,652,1275,1050,241,1718,230,656,1051,231,228,214,1305,658,528;47;M
108701;241,1254,1718,230,227,231,1051,228,214,652,566,658,528,1305,1275;8;M
108813;1275,1305,528,566,656,214,232,1051,231,227,241,1050;11;M
108840;241,1718,230,231,228,1275;23;F
108978;1254,566,1050,241,1718,230,231,228,214,656,652,658,528,1305,1275;44;F
109105;228,231,1305,1275;41;M
109180;241,228,1275;45;F
109360;652,230,228,528,241,231,214;51;M
109444;1254,230,1051,1050,241,1718,227,231,228,214,656,652,658,528,1305;8;F
109810;652,658;34;M
109921;1050,1254,1718,1305,1275;34;M
110018;241,230,231,228,214,652,528;51;F
110080;241,656,652,214;43;F
110163;1050,241,214,652,566,1305;39;F
110164;227,1718,230,1051,658,656,652,566,1305,1275,1050,241,231,228,232;36;M
110183;656,652,658;4;M
110245;1254,1718,241,231,228,652,1305;49;F
110256;652;26;F
110273;230,227,228,231,656,652,658,1718,1051,214,566,1254,1305,528,1275;36;M
110277;1050,241,1718,230,227,231,228,214,656,652,566,658,528,1305,1275;13;M
110286;1050,241,1275,656,231,230,652,566,528,1305,214;61;F
110346;656,232,1718,1254,231,228,652,1305,1275,241,227,214,528;20;F
110430;658,528,1050,230,231,228,214,1305,1254,1718,1051,232,656,1275,227;46;M
110441;214,652,528,241,231,232;36;M
110512;1275,1050,241,1718,230,231,228,232,214,656,652,566,658,528,1305;14;F
110552;227,1275,528,566,656,232,231,230,1718,1050,241,228,214,652,1305;44;F
110564;228,1254,656,1305,241,231,214,652,566,528;68;F
110577;1305,241,1718,231,228,656,652,1275;34;M
110654;232,241;64;M
110681;231,1275,1305,658,566,652,228,232,1051,227,230,1254,241,1050,656;39;F
110839;231,652,656;29;F
111225;566,241,231,228,652,1275;50;F
111238;1275,228,230,231,214,528;45;F
111256;1050,241,1718,230,227,231,1051,228,232,214,656,652,566,658,1305;34;F
111270;241,566,1050;49;M
111274;656,652,566,1254,1051,1275,1305,228,227,528,232,241,231,214,1050;38;F
111301;1718,656,658,1305,1275,652,566,232,228,1051,231,1050,241,214,528;35;M
111417;228,1275,1050,1254,1305,232,227,241,1718,656,652,231,214,528;42;F
111418;1050;49;F
111486;1718,1275,528,566,656,241,227,231,232;39;M
111549;1254,227,1050,241,1718,230,231,1051,228,232,656,652,658,1305,1275;34;F
111620;1051,232,1275;27;F
111628;1275,1305,528,658,566,652,656,214,232,228,231,227,1718,230,241;38;M
111688;1050,241,1254,1718,230,227,231,1051,228,232,656,652,566,658,1305;36;F
111699;652,1305,1275,656,231,227,241,1050,1051,228,528,566,230,232,214;42;F
111785;1305,528,230,228,214;35;F
111788;528,214;42;M
111895;1050,656,658,241,214,528;35;F
111928;1718,231,566,241,1050,1254,230,227,228,214,656,652,528,1305,1275;39;F
111929;241,566,231,656,1305;46;M
111931;658,656,214,232,1051,652,566,231,230,1050,1275,1305,228,227,241;39;F
111938;652,1254,1275,658,228,227,1718,241,231,232,1050,214,656,566,528;33;M
111948;1275;32;F
111975;528,566,232,230,1050,241,231,214;38;M
112410;241,1050,1254,1718,230,227,231,228,214,656,652,658,528,1305,1275;39;M
112431;241,1050,230,231,228,232,656,652,1305;36;M
112440;241,231,232,656,652,566,528,1305,1275;36;F
112447;658,232,1051,230,1718,214,528,652,227,1275,1305,656,228,231,241;48;F
112525;1275,566,652,656,1718,1050,241,1254,227,231,1051,228,214,528,1305;64;F
112552;1254,1050,241,227,231,228,214,656,652,566,528,1305,1275;32;F
112666;1050,241,1718,230,227,231,228,214,656,652,566,658,528,1305,1275;6;F
112686;231,228,656;39;M
112851;232,241,230,227,231,228,214,656,652,528,1305;38;M
112902;1050,1718,230,227,231,1051,228,656,652,566,658;15;F
112906;230,656,214,241,1718,227,652,566,528,1275,1305,1254,228,232,231;42;F
112908;1718,230,227,231,1051,228,232,214,656,652,566,658,528,1305,1275;36;M
113067;241,227,231,228,656,652;41;F
113200;214,1718,231,228,232,652,1275,1305;67;M
113229;1718,1050,227,656,652,566;25;M
113271;1050,1718,230,231,1051,228,566,652,658,1275;15;M
113403;214,566,528,1275,1050,241,1718,1051,232,656,230,231,228,652,1305;61;M
113572;241,1718,231,228,214,652,528,1305;42;F
113676;566,652,232,231,227,1718,241,1050,1275,1254,230,1051,228,214,528;42;F
113934;230,231,652,228,566;48;M
114002;1051,227,231,228,566;46;F
114079;232,1275,241,231,228,652;53;F
114359;241,230,228,214,656,652,528;18;F
114412;232,214,652,528,1275,1050,241,230,227,1051,228,656,566,658,1305;36;F
114414;656,652,228,1305;16;F
114539;241,232;38;F
114540;566,214,241;42;F
114653;1254,241,1275,1305,658,566,652,656,228,231,227,1050,230,214,528;37;F
114668;1254,1051,232,528,228,214,1275;49;F
114702;1050,241,1254,230,227,1051,214,566,528,1305;45;F
114719;232,1051,230,231,228,214,566,528,241,656,1305,1254,227,652,1275;41;F
114721;1050,1718,1051,1305;44;F
114784;1718,1275,1305,528,658,652,656,232,228,1051,231,230,1254,241,1050;30;F
114791;241,214,656,1305,1275,1050;66;F
114833;241,231,658,1254,227,228,214,656,652,528,1305,1275;68;M
114869;1051,1050,241,227,232,214,656,652,528,1305,1275,228,231,230,1718;46;F
114958;1718,1305,652,1051,1254,1050,232,656,231,230,241,228,214,528,1275;40;M
114983;1718,230,231,228,656,652,1305,566,1275;26;M
114999;528,1275,1254,230,231,228,656,652,1305;61;F
115037;228,231;27;F
115124;230,228,231,566;16;M
115135;231,1050,230,228,656,652,1305,1275;44;F
115174;241,231,232,214;40;M
115193;232,241;69;F
115275;1051,230,1050,1718,566,528,1305,1275,241,228,231,656,652,214,227;43;F
115279;230,231,228,652,566;10;F
115316;1254,1050,241;33;M
115376;232,566,528,214,241,1718,227;40;M
115482;1718,1275,1051,1050,241,1254,230,231,228,232,214,656,652,528,1305;35;F
115524;528,214,1051,227,241,566;39;M
115540;1254,232,1050,241,230,227,1051,214,566,658,528;38;F
115618;230,1718,656,1275,1305,652,231,227,232,658,566,1051,228,1050,241;42;M
115691;1051,656,652,231,228,214,528;38;F
115702;232,1254,241,230,214,528;39;M
115734;1050,1718,230,231,228,1275;36;F
115746;1254,231,241,228,214,652,656,528;38;F
115901;1718,231,228,214,652,1305,528;50;F
115918;228;51;F
115945;227,232,1275,566,656,214,228,1051,1050,241,1254,230,231,528,1305;33;F
115948;228;48;M
115962;656,241,1254,214,528;7;M
116031;214;16;F
116298;214;40;F